/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.impl.v1_21_4;

import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.adapter.impl.v1_21_4.PaperweightAdapter;
import com.sk89q.worldedit.bukkit.adapter.impl.v1_21_4.StaticRefraction;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.concurrency.LazyReference;
import com.sk89q.worldedit.world.entity.EntityTypes;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.World;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.enginehub.linbus.tree.LinCompoundTag;
import org.jetbrains.annotations.Nullable;

public class PaperweightServerLevelDelegateProxy
implements InvocationHandler,
AutoCloseable {
    private final EditSession editSession;
    private final WorldServer serverLevel;
    private final PaperweightAdapter adapter;
    private final Map<BlockVector3, TileEntity> createdBlockEntities = new HashMap<BlockVector3, TileEntity>();
    private static final Table<String, MethodType, MethodHandle> METHOD_MAP;

    private static BlockVector3 adapt(BlockPosition blockPos) {
        return BlockVector3.at(blockPos.u(), blockPos.v(), blockPos.w());
    }

    private PaperweightServerLevelDelegateProxy(EditSession editSession, WorldServer serverLevel, PaperweightAdapter adapter) {
        this.editSession = editSession;
        this.serverLevel = serverLevel;
        this.adapter = adapter;
    }

    public static LevelAndProxy newInstance(EditSession editSession, WorldServer serverLevel, PaperweightAdapter adapter) {
        PaperweightServerLevelDelegateProxy proxy = new PaperweightServerLevelDelegateProxy(editSession, serverLevel, adapter);
        return new LevelAndProxy((GeneratorAccessSeed)Proxy.newProxyInstance(serverLevel.getClass().getClassLoader(), serverLevel.getClass().getInterfaces(), (InvocationHandler)proxy), proxy);
    }

    @Nullable
    private TileEntity getBlockEntity(BlockPosition blockPos) {
        BlockVector3 pos = PaperweightServerLevelDelegateProxy.adapt(blockPos);
        return this.createdBlockEntities.get(pos);
    }

    private IBlockData getBlockState(BlockPosition blockPos) {
        return this.adapter.adapt(this.editSession.getBlock(PaperweightServerLevelDelegateProxy.adapt(blockPos)));
    }

    private boolean setBlock(BlockPosition blockPos, IBlockData blockState) {
        try {
            this.handleBlockEntity(blockPos, blockState);
            return this.editSession.setBlock(PaperweightServerLevelDelegateProxy.adapt(blockPos), this.adapter.adapt(blockState));
        }
        catch (MaxChangedBlocksException e) {
            throw new RuntimeException(e);
        }
    }

    private void handleBlockEntity(BlockPosition blockPos, IBlockData blockState) {
        BlockVector3 pos = PaperweightServerLevelDelegateProxy.adapt(blockPos);
        if (blockState.x()) {
            Block block = blockState.b();
            if (!(block instanceof ITileEntity)) {
                throw new AssertionError((Object)("BlockState has block entity but block is not an EntityBlock: " + String.valueOf(blockState)));
            }
            ITileEntity entityBlock = (ITileEntity)block;
            TileEntity newEntity = entityBlock.a(blockPos, blockState);
            if (newEntity != null) {
                newEntity.c(blockState);
                this.createdBlockEntities.put(pos, newEntity);
                return;
            }
        }
        this.createdBlockEntities.remove(pos);
    }

    private boolean removeBlock(BlockPosition blockPos, boolean bl) {
        return this.setBlock(blockPos, Blocks.a.m());
    }

    private boolean addEntity(Entity entity) {
        Vec3D pos = entity.o(0.0f);
        Location location = new Location((Extent)BukkitAdapter.adapt((World)this.serverLevel.getWorld()), pos.a(), pos.b(), pos.c());
        MinecraftKey id = this.serverLevel.K_().e(Registries.z).b((Object)entity.aq());
        NBTTagCompound tag = new NBTTagCompound();
        entity.f(tag);
        BaseEntity baseEntity = new BaseEntity(EntityTypes.get(id.toString()), LazyReference.from(() -> (LinCompoundTag)this.adapter.toNative((NBTBase)tag)));
        return this.editSession.createEntity(location, baseEntity) != null;
    }

    @Override
    public void close() throws MaxChangedBlocksException {
        for (Map.Entry<BlockVector3, TileEntity> entry : this.createdBlockEntities.entrySet()) {
            BlockVector3 blockPos = entry.getKey();
            TileEntity blockEntity = entry.getValue();
            NBTTagCompound tag = blockEntity.c((HolderLookup.a)this.serverLevel.K_());
            this.editSession.setBlock(blockPos, this.adapter.adapt(blockEntity.m()).toBaseBlock(LazyReference.from(() -> (LinCompoundTag)this.adapter.toNative((NBTBase)tag))));
        }
    }

    private static void addMethodHandleToTable(ImmutableTable.Builder<String, MethodType, MethodHandle> table, String methodName, MethodHandle methodHandle) {
        MethodHandle spreader = methodHandle.asSpreader(1, Object[].class, methodHandle.type().parameterCount() - 1);
        table.put((Object)methodName, (Object)methodHandle.type().dropParameterTypes(0, 1).changeReturnType(Void.TYPE), (Object)spreader);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MethodHandle delegate = (MethodHandle)METHOD_MAP.get((Object)method.getName(), (Object)MethodType.methodType(Void.TYPE, method.getParameterTypes()));
        if (delegate != null) {
            return delegate.invoke(this, args);
        }
        return method.invoke((Object)this.serverLevel, args);
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        ImmutableTable.Builder builder = ImmutableTable.builder();
        try {
            PaperweightServerLevelDelegateProxy.addMethodHandleToTable((ImmutableTable.Builder<String, MethodType, MethodHandle>)builder, StaticRefraction.GET_BLOCK_STATE, lookup.unreflect(PaperweightServerLevelDelegateProxy.class.getDeclaredMethod("getBlockState", BlockPosition.class)));
            MethodHandle addEntity = lookup.unreflect(PaperweightServerLevelDelegateProxy.class.getDeclaredMethod("addEntity", Entity.class));
            PaperweightServerLevelDelegateProxy.addMethodHandleToTable((ImmutableTable.Builder<String, MethodType, MethodHandle>)builder, StaticRefraction.ADD_FRESH_ENTITY_WITH_PASSENGERS_ENTITY, addEntity);
            PaperweightServerLevelDelegateProxy.addMethodHandleToTable((ImmutableTable.Builder<String, MethodType, MethodHandle>)builder, StaticRefraction.ADD_FRESH_ENTITY_WITH_PASSENGERS_ENTITY_SPAWN_REASON, MethodHandles.dropArguments(addEntity, 2, new Class[]{CreatureSpawnEvent.SpawnReason.class}));
            PaperweightServerLevelDelegateProxy.addMethodHandleToTable((ImmutableTable.Builder<String, MethodType, MethodHandle>)builder, StaticRefraction.ADD_FRESH_ENTITY, addEntity);
            PaperweightServerLevelDelegateProxy.addMethodHandleToTable((ImmutableTable.Builder<String, MethodType, MethodHandle>)builder, StaticRefraction.ADD_FRESH_ENTITY_SPAWN_REASON, MethodHandles.dropArguments(addEntity, 2, new Class[]{CreatureSpawnEvent.SpawnReason.class}));
            PaperweightServerLevelDelegateProxy.addMethodHandleToTable((ImmutableTable.Builder<String, MethodType, MethodHandle>)builder, StaticRefraction.GET_BLOCK_ENTITY, lookup.unreflect(PaperweightServerLevelDelegateProxy.class.getDeclaredMethod("getBlockEntity", BlockPosition.class)));
            MethodHandle setBlock = lookup.unreflect(PaperweightServerLevelDelegateProxy.class.getDeclaredMethod("setBlock", BlockPosition.class, IBlockData.class));
            PaperweightServerLevelDelegateProxy.addMethodHandleToTable((ImmutableTable.Builder<String, MethodType, MethodHandle>)builder, StaticRefraction.SET_BLOCK, MethodHandles.dropArguments(setBlock, 3, new Class[]{Integer.TYPE}));
            PaperweightServerLevelDelegateProxy.addMethodHandleToTable((ImmutableTable.Builder<String, MethodType, MethodHandle>)builder, StaticRefraction.SET_BLOCK_MAX_UPDATE, MethodHandles.dropArguments(setBlock, 3, new Class[]{Integer.TYPE, Integer.TYPE}));
            MethodHandle removeBlock = lookup.unreflect(PaperweightServerLevelDelegateProxy.class.getDeclaredMethod("removeBlock", BlockPosition.class));
            PaperweightServerLevelDelegateProxy.addMethodHandleToTable((ImmutableTable.Builder<String, MethodType, MethodHandle>)builder, StaticRefraction.REMOVE_BLOCK, MethodHandles.dropArguments(removeBlock, 2, new Class[]{Boolean.TYPE}));
            PaperweightServerLevelDelegateProxy.addMethodHandleToTable((ImmutableTable.Builder<String, MethodType, MethodHandle>)builder, StaticRefraction.DESTROY_BLOCK, MethodHandles.dropArguments(removeBlock, 2, new Class[]{Boolean.TYPE}));
            PaperweightServerLevelDelegateProxy.addMethodHandleToTable((ImmutableTable.Builder<String, MethodType, MethodHandle>)builder, StaticRefraction.DESTROY_BLOCK_BREAKING_ENTITY, MethodHandles.dropArguments(removeBlock, 2, new Class[]{Boolean.TYPE, Entity.class}));
            PaperweightServerLevelDelegateProxy.addMethodHandleToTable((ImmutableTable.Builder<String, MethodType, MethodHandle>)builder, StaticRefraction.DESTROY_BLOCK_BREAKING_ENTITY_MAX_UPDATE, MethodHandles.dropArguments(removeBlock, 2, Boolean.TYPE, Entity.class, Integer.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException("Failed to bind to own methods", e);
        }
        METHOD_MAP = builder.build();
    }

    public record LevelAndProxy(GeneratorAccessSeed level, PaperweightServerLevelDelegateProxy proxy) implements AutoCloseable
    {
        @Override
        public void close() throws MaxChangedBlocksException {
            this.proxy.close();
        }
    }
}

