/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.registry;

import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.translation.TranslationManager;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.registry.BundledItemData;
import com.sk89q.worldedit.world.registry.ItemMaterial;
import com.sk89q.worldedit.world.registry.ItemRegistry;
import com.sk89q.worldedit.world.registry.PassthroughItemMaterial;
import javax.annotation.Nullable;

public class BundledItemRegistry
implements ItemRegistry {
    private BundledItemData.ItemEntry getEntryById(ItemType itemType) {
        return BundledItemData.getInstance().findById(itemType.getId());
    }

    @Override
    public Component getRichName(ItemType itemType) {
        BundledItemData.ItemEntry itemEntry = this.getEntryById(itemType);
        if (itemEntry != null && !itemEntry.localizedName.equals("Air")) {
            return TextComponent.of(itemEntry.localizedName);
        }
        return TranslatableComponent.of(TranslationManager.makeTranslationKey("item", itemType.getId()));
    }

    @Override
    @Nullable
    @Deprecated
    public String getName(ItemType itemType) {
        BundledItemData.ItemEntry itemEntry = this.getEntryById(itemType);
        if (itemEntry != null) {
            String localized = itemEntry.localizedName;
            if (localized.equals("Air")) {
                String id = itemType.getId();
                int c2 = id.indexOf(58);
                return c2 < 0 ? id : id.substring(c2 + 1);
            }
            return localized;
        }
        return null;
    }

    @Override
    @Nullable
    public ItemMaterial getMaterial(ItemType itemType) {
        return new PassthroughItemMaterial(BundledItemData.getInstance().getMaterialById(itemType.getId()));
    }
}

