/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.base.Preconditions;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.Logging;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.function.FlatRegionFunction;
import com.sk89q.worldedit.function.FlatRegionMaskingFilter;
import com.sk89q.worldedit.function.biome.BiomeReplace;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.Mask2D;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.function.visitor.FlatRegionVisitor;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.FlatRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.Regions;
import com.sk89q.worldedit.util.command.binding.Switch;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.biome.BiomeData;
import com.sk89q.worldedit.world.registry.BiomeRegistry;
import java.util.HashSet;
import java.util.List;

public class BiomeCommands {
    private final WorldEdit worldEdit;

    public BiomeCommands(WorldEdit worldEdit) {
        Preconditions.checkNotNull((Object)worldEdit);
        this.worldEdit = worldEdit;
    }

    @Command(aliases={"biomelist", "biomels"}, usage="[page]", desc="Gets all biomes available.", max=1)
    @CommandPermissions(value={"worldedit.biome.list"})
    public void biomeList(Player player, CommandContext args) throws WorldEditException {
        int offset;
        int page;
        int count = 0;
        if (args.argsLength() == 0 || (page = args.getInteger(0)) < 2) {
            page = 1;
            offset = 0;
        } else {
            offset = (page - 1) * 19;
        }
        BiomeRegistry biomeRegistry = player.getWorld().getWorldData().getBiomeRegistry();
        List<BaseBiome> biomes = biomeRegistry.getBiomes();
        int totalPages = biomes.size() / 19 + 1;
        player.print("Available Biomes (page " + page + "/" + totalPages + ") :");
        for (BaseBiome biome : biomes) {
            if (offset > 0) {
                --offset;
                continue;
            }
            BiomeData data = biomeRegistry.getData(biome);
            if (data != null) {
                player.print(" " + data.getName());
                if (++count != 19) continue;
                break;
            }
            player.print(" <unknown #" + biome.getId() + ">");
        }
    }

    @Command(aliases={"biomeinfo"}, flags="pt", desc="Get the biome of the targeted block.", help="Get the biome of the block.\nBy default use all the blocks contained in your selection.\n-t use the block you are looking at.\n-p use the block you are currently in", max=0)
    @CommandPermissions(value={"worldedit.biome.info"})
    public void biomeInfo(Player player, LocalSession session, CommandContext args) throws WorldEditException {
        String qualifier;
        BiomeRegistry biomeRegistry = player.getWorld().getWorldData().getBiomeRegistry();
        HashSet<BaseBiome> biomes = new HashSet<BaseBiome>();
        if (args.hasFlag('t')) {
            WorldVector blockPosition = player.getBlockTrace(300);
            if (blockPosition == null) {
                player.printError("No block in sight!");
                return;
            }
            BaseBiome biome = player.getWorld().getBiome(blockPosition.toVector2D());
            biomes.add(biome);
            qualifier = "at line of sight point";
        } else if (args.hasFlag('p')) {
            BaseBiome biome = player.getWorld().getBiome(player.getPosition().toVector2D());
            biomes.add(biome);
            qualifier = "at your position";
        } else {
            World world = player.getWorld();
            Region region = session.getSelection(world);
            if (region instanceof FlatRegion) {
                for (Vector2D vector2D : ((FlatRegion)region).asFlatRegion()) {
                    biomes.add(world.getBiome(vector2D));
                }
            } else {
                for (Vector vector : region) {
                    biomes.add(world.getBiome(vector.toVector2D()));
                }
            }
            qualifier = "in your selection";
        }
        player.print(biomes.size() != 1 ? "Biomes " + qualifier + ":" : "Biome " + qualifier + ":");
        for (BaseBiome biome : biomes) {
            BiomeData data = biomeRegistry.getData(biome);
            if (data != null) {
                player.print(" " + data.getName());
                continue;
            }
            player.print(" <unknown #" + biome.getId() + ">");
        }
    }

    @Command(aliases={"/setbiome"}, usage="<biome>", flags="p", desc="Sets the biome of the player's current block or region.", help="Set the biome of the region.\nBy default use all the blocks contained in your selection.\n-p use the block you are currently in")
    @Logging(value=Logging.LogMode.REGION)
    @CommandPermissions(value={"worldedit.biome.set"})
    public void setBiome(Player player, LocalSession session, EditSession editSession, BaseBiome target, @Switch(value=112) boolean atPosition) throws WorldEditException {
        World world = player.getWorld();
        Mask mask = editSession.getMask();
        Mask2D mask2d = mask != null ? mask.toMask2D() : null;
        Region region = atPosition ? new CuboidRegion(player.getPosition(), player.getPosition()) : session.getSelection(world);
        FlatRegionFunction replace = new BiomeReplace(editSession, target);
        if (mask2d != null) {
            replace = new FlatRegionMaskingFilter(mask2d, replace);
        }
        FlatRegionVisitor visitor = new FlatRegionVisitor(Regions.asFlatRegion(region), replace);
        Operations.completeLegacy(visitor);
        player.print("Biomes were changed in " + visitor.getAffected() + " columns. You may have to rejoin your game (or close and reopen your world) to see a change.");
    }
}

