/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.utils;

import java.lang.reflect.Field;

public class FieldReplacer<Instance, Type> {
    private final Class<Type> requiredType;
    private final Field field;

    public FieldReplacer(Class<? extends Instance> clazz, String fieldName, Class<Type> requiredType) {
        try {
            this.requiredType = requiredType;
            this.field = clazz.getDeclaredField(fieldName);
            this.field.setAccessible(true);
            if (!requiredType.isAssignableFrom(this.field.getType())) {
                throw new ExceptionInInitializerError("Field of wrong type");
            }
        }
        catch (NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public Type get(Instance instance) {
        try {
            return this.requiredType.cast(this.field.get(instance));
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }

    public void set(Instance instance, Type newValue) {
        try {
            this.field.set(instance, newValue);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }
}

