/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.bukkit.regexperms;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.PluginManager;
import ru.tehkode.utils.FieldReplacer;

public class PermissionList
extends HashMap<String, Permission> {
    private static FieldReplacer<PluginManager, Map> INJECTOR;
    private static final Map<Class<?>, FieldReplacer<Permission, Map>> CHILDREN_MAPS;
    private final Multimap<String, Map.Entry<String, Boolean>> childParentMapping = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());

    public PermissionList() {
    }

    public PermissionList(Map<? extends String, ? extends Permission> existing) {
        super(existing);
    }

    private FieldReplacer<Permission, Map> getFieldReplacer(Permission perm) {
        FieldReplacer<Object, Map> ret = CHILDREN_MAPS.get(perm.getClass());
        if (ret == null) {
            ret = new FieldReplacer(perm.getClass(), "children", Map.class);
            CHILDREN_MAPS.put(perm.getClass(), ret);
        }
        return ret;
    }

    private void removeAllChildren(String perm) {
        Iterator it = this.childParentMapping.entries().iterator();
        while (it.hasNext()) {
            if (!((String)((Map.Entry)((Map.Entry)it.next()).getValue()).getKey()).equals(perm)) continue;
            it.remove();
        }
    }

    public static PermissionList inject(PluginManager manager) {
        if (INJECTOR == null) {
            INJECTOR = new FieldReplacer(manager.getClass(), "permissions", Map.class);
        }
        Map existing = INJECTOR.get(manager);
        PermissionList list = new PermissionList(existing);
        INJECTOR.set(manager, list);
        return list;
    }

    @Override
    public Permission put(String k, Permission v) {
        for (Map.Entry ent : v.getChildren().entrySet()) {
            this.childParentMapping.put(ent.getKey(), new AbstractMap.SimpleEntry(v.getName(), ent.getValue()));
        }
        FieldReplacer<Permission, Map> repl = this.getFieldReplacer(v);
        repl.set(v, new NotifyingChildrenMap(v));
        return super.put(k, v);
    }

    @Override
    public Permission remove(Object k) {
        this.removeAllChildren(k.toString());
        Permission ret = (Permission)super.remove(k);
        if (ret != null) {
            this.getFieldReplacer(ret).set(ret, new LinkedHashMap(ret.getChildren()));
        }
        return ret;
    }

    @Override
    public void clear() {
        this.childParentMapping.clear();
        super.clear();
    }

    public Collection<Map.Entry<String, Boolean>> getParents(String permission) {
        return this.childParentMapping.get((Object)permission.toLowerCase());
    }

    static {
        CHILDREN_MAPS = new HashMap();
    }

    private class NotifyingChildrenMap
    extends LinkedHashMap<String, Boolean> {
        private final Permission perm;

        public NotifyingChildrenMap(Permission perm) {
            super(perm.getChildren());
            this.perm = perm;
        }

        @Override
        public Boolean remove(Object perm) {
            this.removeFromMapping(String.valueOf(perm));
            return (Boolean)super.remove(perm);
        }

        private void removeFromMapping(String child) {
            Iterator it = PermissionList.this.childParentMapping.get((Object)child).iterator();
            while (it.hasNext()) {
                if (!((String)((Map.Entry)it.next()).getKey()).equals(this.perm.getName())) continue;
                it.remove();
            }
        }

        @Override
        public Boolean put(String perm, Boolean val) {
            PermissionList.this.childParentMapping.put((Object)perm, new AbstractMap.SimpleEntry<String, Boolean>(this.perm.getName(), val));
            return super.put(perm, val);
        }

        @Override
        public void clear() {
            PermissionList.this.removeAllChildren(this.perm.getName());
            super.clear();
        }
    }
}

