/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.bukkit.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import ru.tehkode.permissions.PermissionManager;
import ru.tehkode.permissions.bukkit.PermissionsEx;
import ru.tehkode.permissions.bukkit.commands.PermissionsCommand;
import ru.tehkode.permissions.commands.Command;
import ru.tehkode.utils.StringUtils;

public class WorldCommands
extends PermissionsCommand {
    @Command(name="pex", syntax="worlds", description="Print loaded worlds", isPrimary=true, permission="permissions.manage.worlds")
    public void worldsTree(PermissionsEx plugin, CommandSender sender, Map<String, String> args) {
        List worlds = plugin.getServer().getWorlds();
        PermissionManager manager = plugin.getPermissionsManager();
        sender.sendMessage("Worlds on server: ");
        for (World world : worlds) {
            List<String> parentWorlds = manager.getWorldInheritance(world.getName());
            String output = "  " + world.getName();
            if (!parentWorlds.isEmpty()) {
                output = output + ChatColor.GREEN + " [" + ChatColor.WHITE + StringUtils.implode(parentWorlds, ", ") + ChatColor.GREEN + "]";
            }
            sender.sendMessage(output);
        }
    }

    @Command(name="pex", syntax="world <world>", description="Print <world> inheritance info", permission="permissions.manage.worlds")
    public void worldPrintInheritance(PermissionsEx plugin, CommandSender sender, Map<String, String> args) {
        String worldName = this.autoCompleteWorldName(args.get("world"));
        PermissionManager manager = plugin.getPermissionsManager();
        if (plugin.getServer().getWorld(worldName) == null) {
            sender.sendMessage("Specified world \"" + args.get("world") + "\" not found.");
            return;
        }
        List<String> parentWorlds = manager.getWorldInheritance(worldName);
        sender.sendMessage("World " + worldName + " inherits:");
        if (parentWorlds.isEmpty()) {
            sender.sendMessage("nothing :3");
            return;
        }
        for (String parentWorld : parentWorlds) {
            List<String> parents = manager.getWorldInheritance(parentWorld);
            String output = "  " + parentWorld;
            if (!parents.isEmpty()) {
                output = output + ChatColor.GREEN + " [" + ChatColor.WHITE + StringUtils.implode(parents, ", ") + ChatColor.GREEN + "]";
            }
            sender.sendMessage(output);
        }
    }

    @Command(name="pex", syntax="world <world> inherit <parentWorlds>", description="Set <parentWorlds> for <world>", permission="permissions.manage.worlds.inheritance")
    public void worldSetInheritance(PermissionsEx plugin, CommandSender sender, Map<String, String> args) {
        String worldName = this.autoCompleteWorldName(args.get("world"));
        PermissionManager manager = plugin.getPermissionsManager();
        if (plugin.getServer().getWorld(worldName) == null) {
            sender.sendMessage("Specified world \"" + args.get("world") + "\" not found.");
            return;
        }
        ArrayList<String> parents = new ArrayList<String>();
        String parentWorlds = args.get("parentWorlds");
        if (parentWorlds.contains(",")) {
            for (String world : parentWorlds.split(",")) {
                if (parents.contains(world = this.autoCompleteWorldName(world, "parentWorlds"))) continue;
                parents.add(world.trim());
            }
        } else {
            parents.add(parentWorlds.trim());
        }
        manager.setWorldInheritance(worldName, parents);
        sender.sendMessage("World " + worldName + " inherits " + StringUtils.implode(parents, ", "));
    }
}

