/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.backends.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import ru.tehkode.permissions.PermissionsGroupData;
import ru.tehkode.permissions.PermissionsUserData;
import ru.tehkode.permissions.backends.sql.SQLBackend;
import ru.tehkode.permissions.backends.sql.SQLConnection;

public class SQLData
implements PermissionsUserData,
PermissionsGroupData {
    private String identifier;
    private final Type type;
    private final SQLBackend backend;
    private final AtomicBoolean virtual = new AtomicBoolean(true);
    private volatile boolean globalDef;
    private volatile String globalPrefix;
    private volatile String globalSuffix;

    public SQLData(String identifier, Type type, SQLBackend backend) {
        this.identifier = identifier;
        this.type = type;
        this.backend = backend;
        this.fetchInfo();
    }

    private String emptyToNull(String enter) {
        if (enter == null || enter.equals("null")) {
            return null;
        }
        return enter;
    }

    private String nullToEmpty(String enter) {
        if (enter == null) {
            return "null";
        }
        return enter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateInfo() {
        block15: {
            try {
                SQLConnection conn;
                block16: {
                    conn = this.backend.getSQL();
                    Throwable throwable = null;
                    try {
                        String sql = this.isVirtual() ? "INSERT INTO `{permissions_entity}` (`prefix`, `suffix`, `default`, `name`, `type`) VALUES (?, ?, ?, ?, ?)" : "UPDATE `{permissions_entity}` SET `prefix` = ?, `suffix` = ?, `default` = ? WHERE `name` = ? AND `type` = ?";
                        conn.prepAndBind(sql, this.nullToEmpty(this.globalPrefix), this.nullToEmpty(this.globalSuffix), this.globalDef ? 1 : 0, this.getIdentifier(), this.type.ordinal()).execute();
                        if (conn == null) break block15;
                        if (throwable == null) break block16;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (conn == null) throw throwable3;
                            if (throwable == null) {
                                conn.close();
                                throw throwable3;
                            }
                            try {
                                conn.close();
                                throw throwable3;
                            }
                            catch (Throwable x2) {
                                try {
                                    throwable.addSuppressed(x2);
                                    throw throwable3;
                                }
                                catch (NoSuchMethodError noSuchMethodError) {
                                    throw throwable3;
                                }
                            }
                        }
                    }
                    try {
                        conn.close();
                    }
                    catch (Throwable x2) {
                        try {
                            throwable.addSuppressed(x2);
                            break block15;
                        }
                        catch (NoSuchMethodError noSuchMethodError) {}
                    }
                    break block15;
                }
                conn.close();
            }
            catch (SQLException e) {
                if (!this.virtual.compareAndSet(true, false)) throw new RuntimeException(e);
                this.updateInfo();
                throw new RuntimeException(e);
            }
        }
        this.virtual.set(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void fetchInfo() {
        try {
            SQLConnection conn;
            block17: {
                conn = this.backend.getSQL();
                Throwable throwable = null;
                try {
                    ResultSet result = conn.prepAndBind("SELECT `name`, `prefix`, `suffix`, `default` FROM `{permissions_entity}` WHERE `name` = ? AND `type` = ? LIMIT 1", this.getIdentifier(), this.type.ordinal()).executeQuery();
                    if (result.next()) {
                        this.globalPrefix = this.emptyToNull(result.getString("prefix"));
                        this.globalSuffix = this.emptyToNull(result.getString("suffix"));
                        this.globalDef = result.getBoolean("default");
                        this.identifier = result.getString("name");
                        this.virtual.set(false);
                    } else {
                        this.globalPrefix = null;
                        this.globalSuffix = null;
                        this.virtual.set(true);
                    }
                    if (conn == null) return;
                    if (throwable == null) break block17;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (conn == null) throw throwable3;
                        if (throwable == null) {
                            conn.close();
                            throw throwable3;
                        }
                        try {
                            conn.close();
                            throw throwable3;
                        }
                        catch (Throwable x2) {
                            try {
                                throwable.addSuppressed(x2);
                                throw throwable3;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable3;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return;
                }
                catch (Throwable x2) {
                    try {
                        throwable.addSuppressed(x2);
                        return;
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return;
                    }
                }
            }
            conn.close();
            return;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setIdentifier(String identifier) {
        try {
            boolean bl;
            Throwable throwable;
            SQLConnection conn;
            block29: {
                block27: {
                    boolean bl2;
                    block28: {
                        block25: {
                            boolean bl3;
                            block26: {
                                conn = this.backend.getSQL();
                                throwable = null;
                                ResultSet set = conn.prepAndBind("SELECT `id` from `{permissions_entity}` WHERE `name` = ? AND `type` = ? LIMIT 1", identifier, this.type.ordinal()).executeQuery();
                                if (!set.next()) break block25;
                                bl3 = false;
                                if (conn == null) return bl3;
                                if (throwable == null) break block26;
                                try {
                                    conn.close();
                                    return bl3;
                                }
                                catch (Throwable x2) {
                                    try {
                                        throwable.addSuppressed(x2);
                                        return bl3;
                                    }
                                    catch (NoSuchMethodError noSuchMethodError) {
                                        return bl3;
                                    }
                                }
                            }
                            conn.close();
                            return bl3;
                        }
                        if (!this.isVirtual()) break block27;
                        this.identifier = identifier;
                        bl2 = true;
                        if (conn == null) return bl2;
                        if (throwable == null) break block28;
                        try {
                            conn.close();
                            return bl2;
                        }
                        catch (Throwable x2) {
                            try {
                                throwable.addSuppressed(x2);
                                return bl2;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                return bl2;
                            }
                        }
                    }
                    conn.close();
                    return bl2;
                }
                conn.prepAndBind("UPDATE `{permissions_entity}` SET `name` = ? WHERE `name` = ? AND `type` = ?", identifier, this.identifier, this.type.ordinal()).execute();
                conn.prepAndBind("UPDATE `{permissions}` SET `name` = ? WHERE `name` = ? AND `type` = ?", identifier, this.identifier, this.type.ordinal()).execute();
                conn.prepAndBind("UPDATE `{permissions_inheritance}` SET `child` = ? WHERE `child` = ? AND `type` = ?", identifier, this.identifier, this.type.ordinal()).execute();
                this.identifier = identifier;
                bl = true;
                if (conn == null) return bl;
                if (throwable == null) break block29;
                try {
                    conn.close();
                    return bl;
                }
                catch (Throwable x2) {
                    try {
                        throwable.addSuppressed(x2);
                        return bl;
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return bl;
                    }
                }
            }
            conn.close();
            return bl;
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (conn == null) throw throwable3;
                    if (throwable == null) {
                        conn.close();
                        throw throwable3;
                    }
                    try {
                        conn.close();
                        throw throwable3;
                    }
                    catch (Throwable x2) {
                        try {
                            throwable.addSuppressed(x2);
                            throw throwable3;
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            throw throwable3;
                        }
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> getPermissions(String worldName) {
        try {
            List<String> list;
            SQLConnection conn;
            block16: {
                conn = this.backend.getSQL();
                Throwable throwable = null;
                try {
                    LinkedList<String> permissions = new LinkedList<String>();
                    ResultSet set = conn.prepAndBind("SELECT `permission` FROM `{permissions}` WHERE `name` = ? AND `type` = ? AND `world` = ? AND LENGTH(`value`) = 0 ORDER BY `id` DESC", this.getIdentifier(), this.type.ordinal(), worldName == null ? "" : worldName).executeQuery();
                    while (set.next()) {
                        permissions.add(set.getString("permission"));
                    }
                    list = Collections.unmodifiableList(permissions);
                    if (conn == null) return list;
                    if (throwable == null) break block16;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (conn == null) throw throwable3;
                        if (throwable == null) {
                            conn.close();
                            throw throwable3;
                        }
                        try {
                            conn.close();
                            throw throwable3;
                        }
                        catch (Throwable x2) {
                            try {
                                throwable.addSuppressed(x2);
                                throw throwable3;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable3;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return list;
                }
                catch (Throwable x2) {
                    try {
                        throwable.addSuppressed(x2);
                        return list;
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return list;
                    }
                }
            }
            conn.close();
            return list;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setPermissions(List<String> permissions, String worldName) {
        block18: {
            if (worldName == null) {
                worldName = "";
            }
            try {
                SQLConnection conn;
                block19: {
                    conn = this.backend.getSQL();
                    Throwable throwable = null;
                    try {
                        conn.prepAndBind("DELETE FROM `{permissions}` WHERE `name` = ? AND `type` = ? AND `world` = ? AND `value` = ''", this.getIdentifier(), this.type.ordinal(), worldName).execute();
                        if (permissions.size() > 0) {
                            HashSet<String> includedPerms = new HashSet<String>();
                            PreparedStatement statement = conn.prepAndBind("INSERT INTO `{permissions}` (`name`, `permission`, `value`, `world`, `type`) VALUES (?, ?, '', ?, ?)", this.getIdentifier(), "toset", worldName, this.type.ordinal());
                            for (int i = permissions.size() - 1; i >= 0; --i) {
                                if (includedPerms.contains(permissions.get(i))) continue;
                                statement.setString(2, permissions.get(i));
                                statement.addBatch();
                                includedPerms.add(permissions.get(i));
                            }
                            statement.executeBatch();
                        }
                        if (conn == null) break block18;
                        if (throwable == null) break block19;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (conn == null) throw throwable3;
                            if (throwable == null) {
                                conn.close();
                                throw throwable3;
                            }
                            try {
                                conn.close();
                                throw throwable3;
                            }
                            catch (Throwable x2) {
                                try {
                                    throwable.addSuppressed(x2);
                                    throw throwable3;
                                }
                                catch (NoSuchMethodError noSuchMethodError) {
                                    throw throwable3;
                                }
                            }
                        }
                    }
                    try {
                        conn.close();
                    }
                    catch (Throwable x2) {
                        try {
                            throwable.addSuppressed(x2);
                            break block18;
                        }
                        catch (NoSuchMethodError noSuchMethodError) {}
                    }
                    break block18;
                }
                conn.close();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        if (permissions.size() <= 0) return;
        if (!this.isVirtual()) return;
        this.save();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, List<String>> getPermissionsMap() {
        HashMap<String, LinkedList<String>> allPermissions;
        block19: {
            allPermissions = new HashMap<String, LinkedList<String>>();
            try {
                SQLConnection conn;
                block20: {
                    conn = this.backend.getSQL();
                    Throwable throwable = null;
                    try {
                        ResultSet res = conn.prepAndBind("SELECT `permission`, `world` FROM `{permissions}` WHERE `name` = ? AND `type` = ? AND LENGTH(`value`) = 0 ORDER BY `id` DESC", this.getIdentifier(), this.type.ordinal()).executeQuery();
                        while (res.next()) {
                            LinkedList<String> perms;
                            String world = res.getString("world");
                            if (world.isEmpty()) {
                                world = null;
                            }
                            if ((perms = (LinkedList<String>)allPermissions.get(world)) == null) {
                                perms = new LinkedList<String>();
                                allPermissions.put(world, perms);
                            }
                            perms.add(res.getString("permission"));
                        }
                        if (conn == null) break block19;
                        if (throwable == null) break block20;
                    }
                    catch (Throwable x2) {
                        try {
                            throwable = x2;
                            throw x2;
                        }
                        catch (Throwable throwable2) {
                            if (conn == null) throw throwable2;
                            if (throwable == null) {
                                conn.close();
                                throw throwable2;
                            }
                            try {
                                conn.close();
                                throw throwable2;
                            }
                            catch (Throwable x22) {
                                try {
                                    throwable.addSuppressed(x22);
                                    throw throwable2;
                                }
                                catch (NoSuchMethodError noSuchMethodError) {
                                    throw throwable2;
                                }
                            }
                        }
                    }
                    try {
                        conn.close();
                    }
                    catch (Throwable x2) {
                        try {
                            throwable.addSuppressed(x2);
                            break block19;
                        }
                        catch (NoSuchMethodError noSuchMethodError) {}
                    }
                    break block19;
                }
                conn.close();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        HashMap ret = new HashMap();
        Iterator i$ = allPermissions.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry e = i$.next();
            ret.put(e.getKey(), Collections.unmodifiableList((List)e.getValue()));
        }
        return Collections.unmodifiableMap(ret);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<String> getWorlds() {
        HashSet<String> worlds = new HashSet<String>();
        try {
            Set<String> set;
            SQLConnection conn;
            block17: {
                conn = this.backend.getSQL();
                Throwable throwable = null;
                try {
                    ResultSet res = conn.prepAndBind("SELECT `world` FROM `{permissions}` WHERE `name` = ? AND `type` = ?", this.getIdentifier(), this.type.ordinal()).executeQuery();
                    while (res.next()) {
                        worlds.add(res.getString("world"));
                    }
                    res = conn.prepAndBind("SELECT `world` FROM `{permissions_inheritance}` WHERE `child` = ? AND `type` = ?", this.getIdentifier(), this.type.ordinal()).executeQuery();
                    while (res.next()) {
                        worlds.add(res.getString("world"));
                    }
                    worlds.remove("");
                    set = Collections.unmodifiableSet(worlds);
                    if (conn == null) return set;
                    if (throwable == null) break block17;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (conn == null) throw throwable3;
                        if (throwable == null) {
                            conn.close();
                            throw throwable3;
                        }
                        try {
                            conn.close();
                            throw throwable3;
                        }
                        catch (Throwable x2) {
                            try {
                                throwable.addSuppressed(x2);
                                throw throwable3;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable3;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return set;
                }
                catch (Throwable x2) {
                    try {
                        throwable.addSuppressed(x2);
                        return set;
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return set;
                    }
                }
            }
            conn.close();
            return set;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getOption(String option, String worldName) {
        if (worldName == null || worldName.isEmpty()) {
            if (option.equals("prefiix")) {
                return this.globalPrefix;
            }
            if (option.equals("suffix")) {
                return this.globalSuffix;
            }
        }
        try {
            Throwable throwable;
            SQLConnection conn;
            block23: {
                String string;
                block24: {
                    conn = this.backend.getSQL();
                    throwable = null;
                    try {
                        ResultSet res = conn.prepAndBind("SELECT `value` FROM `{permissions}` WHERE `name` = ? AND `type` = ? AND `permission` = ? AND `world` = ? AND LENGTH(`value`) > 0 LIMIT 1", this.getIdentifier(), this.type.ordinal(), option, worldName == null ? "" : worldName).executeQuery();
                        if (!res.next()) break block23;
                        string = res.getString("value");
                        if (conn == null) return string;
                        if (throwable == null) break block24;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (conn == null) throw throwable3;
                            if (throwable == null) {
                                conn.close();
                                throw throwable3;
                            }
                            try {
                                conn.close();
                                throw throwable3;
                            }
                            catch (Throwable x2) {
                                try {
                                    throwable.addSuppressed(x2);
                                    throw throwable3;
                                }
                                catch (NoSuchMethodError noSuchMethodError) {
                                    throw throwable3;
                                }
                            }
                        }
                    }
                    try {
                        conn.close();
                        return string;
                    }
                    catch (Throwable x2) {
                        try {
                            throwable.addSuppressed(x2);
                            return string;
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            return string;
                        }
                    }
                }
                conn.close();
                return string;
            }
            if (conn == null) return null;
            if (throwable == null) {
                conn.close();
                return null;
            }
            try {
                conn.close();
                return null;
            }
            catch (Throwable x2) {
                try {
                    throwable.addSuppressed(x2);
                    return null;
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    return null;
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setOption(String option, String value, String worldName) {
        if (option == null) return;
        if (option.isEmpty()) {
            return;
        }
        if (worldName == null) {
            worldName = "";
        }
        if (worldName.isEmpty()) {
            if (option.equals("prefix")) {
                this.globalPrefix = value;
                this.updateInfo();
                return;
            }
            if (option.equals("suffix")) {
                this.globalSuffix = value;
                this.updateInfo();
                return;
            }
        }
        if (value == null || value.isEmpty()) {
            try {
                SQLConnection conn;
                block38: {
                    conn = this.backend.getSQL();
                    Throwable throwable = null;
                    try {
                        conn.prepAndBind("DELETE FROM `{permissions}` WHERE `name` = ? AND `permission` = ? AND `type` = ? AND `world` = ? AND LENGTH(`value`) > 0", this.getIdentifier(), option, this.type.ordinal(), worldName).execute();
                        if (conn == null) return;
                        if (throwable == null) break block38;
                    }
                    catch (Throwable x2) {
                        try {
                            throwable = x2;
                            throw x2;
                        }
                        catch (Throwable throwable2) {
                            if (conn == null) throw throwable2;
                            if (throwable == null) {
                                conn.close();
                                throw throwable2;
                            }
                            try {
                                conn.close();
                                throw throwable2;
                            }
                            catch (Throwable x22) {
                                try {
                                    throwable.addSuppressed(x22);
                                    throw throwable2;
                                }
                                catch (NoSuchMethodError noSuchMethodError) {
                                    throw throwable2;
                                }
                            }
                        }
                    }
                    try {
                        conn.close();
                        return;
                    }
                    catch (Throwable x2) {
                        try {
                            throwable.addSuppressed(x2);
                            return;
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            return;
                        }
                    }
                }
                conn.close();
                return;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            SQLConnection conn;
            block39: {
                conn = this.backend.getSQL();
                Throwable throwable = null;
                try {
                    if (this.backend.dbDriver.equals("sqlite")) {
                        conn.prepAndBind("INSERT OR REPLACE INTO `{permissions}` (`name`, `type`, `permission`, `world`, `value`) VALUES (?, ?, ?, ?, ?)", this.getIdentifier(), this.type.ordinal(), option, worldName, value).execute();
                    } else {
                        conn.prepAndBind("INSERT INTO `{permissions}` (`name`, `type`, `permission`, `world`, `value`) VALUES (?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE `value` = VALUES(`value`)", this.getIdentifier(), this.type.ordinal(), option, worldName, value).execute();
                    }
                    if (conn == null) return;
                    if (throwable == null) break block39;
                }
                catch (Throwable throwable3) {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (conn == null) throw throwable4;
                        if (throwable == null) {
                            conn.close();
                            throw throwable4;
                        }
                        try {
                            conn.close();
                            throw throwable4;
                        }
                        catch (Throwable x2) {
                            try {
                                throwable.addSuppressed(x2);
                                throw throwable4;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable4;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return;
                }
                catch (Throwable x2) {
                    try {
                        throwable.addSuppressed(x2);
                        return;
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return;
                    }
                }
            }
            conn.close();
            return;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private <K, V> void putIfNotNull(Map<K, V> map, K key, V value) {
        if (value != null) {
            map.put(key, value);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, String> getOptions(String worldName) {
        HashMap<String, String> options = new HashMap<String, String>();
        if (worldName == null || worldName.isEmpty()) {
            this.putIfNotNull(options, "prefix", this.globalPrefix);
            this.putIfNotNull(options, "suffix", this.globalSuffix);
        }
        try {
            SQLConnection conn;
            block17: {
                conn = this.backend.getSQL();
                Throwable throwable = null;
                try {
                    ResultSet set = conn.prepAndBind("SELECT `permission`, `value` FROM `{permissions}` WHERE `name` = ? AND `type` = ? AND `world` = ? AND LENGTH(`value`) > 0", this.getIdentifier(), this.type.ordinal(), worldName == null ? "" : worldName).executeQuery();
                    while (set.next()) {
                        options.put(set.getString("permission"), set.getString("value"));
                    }
                    if (conn == null) return Collections.unmodifiableMap(options);
                    if (throwable == null) break block17;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (conn == null) throw throwable3;
                        if (throwable == null) {
                            conn.close();
                            throw throwable3;
                        }
                        try {
                            conn.close();
                            throw throwable3;
                        }
                        catch (Throwable x2) {
                            try {
                                throwable.addSuppressed(x2);
                                throw throwable3;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable3;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return Collections.unmodifiableMap(options);
                }
                catch (Throwable x2) {
                    try {
                        throwable.addSuppressed(x2);
                        return Collections.unmodifiableMap(options);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return Collections.unmodifiableMap(options);
                    }
                }
            }
            conn.close();
            return Collections.unmodifiableMap(options);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, Map<String, String>> getOptionsMap() {
        HashMap allOptions = new HashMap();
        HashMap globalOpts = new HashMap();
        allOptions.put(null, globalOpts);
        this.putIfNotNull(globalOpts, "prefix", this.globalPrefix);
        this.putIfNotNull(globalOpts, "suffix", this.globalSuffix);
        try {
            SQLConnection conn;
            block18: {
                conn = this.backend.getSQL();
                Throwable throwable = null;
                try {
                    ResultSet res = conn.prepAndBind("SELECT `permission`, `value`, `world` FROM `{permissions}` WHERE `name` = ? AND `type` = ? AND LENGTH(`value`) > 0", this.getIdentifier(), this.type.ordinal()).executeQuery();
                    while (res.next()) {
                        HashMap<String, String> worldOpts;
                        String world = res.getString("world");
                        if (world.isEmpty()) {
                            world = null;
                        }
                        if ((worldOpts = (HashMap<String, String>)allOptions.get(world)) == null) {
                            worldOpts = new HashMap<String, String>();
                            allOptions.put(world, worldOpts);
                        }
                        worldOpts.put(res.getString("permission"), res.getString("value"));
                    }
                    if (conn == null) return Collections.unmodifiableMap(allOptions);
                    if (throwable == null) break block18;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (conn == null) throw throwable3;
                        if (throwable == null) {
                            conn.close();
                            throw throwable3;
                        }
                        try {
                            conn.close();
                            throw throwable3;
                        }
                        catch (Throwable x2) {
                            try {
                                throwable.addSuppressed(x2);
                                throw throwable3;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable3;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return Collections.unmodifiableMap(allOptions);
                }
                catch (Throwable x2) {
                    try {
                        throwable.addSuppressed(x2);
                        return Collections.unmodifiableMap(allOptions);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return Collections.unmodifiableMap(allOptions);
                    }
                }
            }
            conn.close();
            return Collections.unmodifiableMap(allOptions);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isVirtual() {
        return this.virtual.get();
    }

    @Override
    public void save() {
        this.updateInfo();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void remove() {
        if (!this.virtual.compareAndSet(false, true)) return;
        try {
            SQLConnection conn;
            block15: {
                conn = this.backend.getSQL();
                Throwable throwable = null;
                try {
                    conn.prepAndBind("DELETE FROM `{permissions_inheritance}` WHERE `child` = ? AND `type` = ?", this.getIdentifier(), this.type.ordinal()).execute();
                    conn.prepAndBind("DELETE FROM `{permissions}` WHERE `name` = ? AND `type` = ?", this.getIdentifier(), this.type.ordinal()).execute();
                    conn.prepAndBind("DELETE FROM `{permissions_entity}` WHERE `name` = ? AND `type` = ?", this.getIdentifier(), this.type.ordinal()).execute();
                    if (conn == null) return;
                    if (throwable == null) break block15;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (conn == null) throw throwable3;
                        if (throwable == null) {
                            conn.close();
                            throw throwable3;
                        }
                        try {
                            conn.close();
                            throw throwable3;
                        }
                        catch (Throwable x2) {
                            try {
                                throwable.addSuppressed(x2);
                                throw throwable3;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable3;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return;
                }
                catch (Throwable x2) {
                    try {
                        throwable.addSuppressed(x2);
                        return;
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return;
                    }
                }
            }
            conn.close();
            return;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, List<String>> getParentsMap() {
        HashMap<String, LinkedList<String>> ret = new HashMap<String, LinkedList<String>>();
        try {
            SQLConnection conn;
            block17: {
                conn = this.backend.getSQL();
                Throwable throwable = null;
                try {
                    ResultSet res = conn.prepAndBind("SELECT `parent`, `world` FROM `{permissions_inheritance}` WHERE `child` = ? AND `type` = ? ORDER BY `id` DESC", this.getIdentifier(), this.type.ordinal()).executeQuery();
                    while (res.next()) {
                        String world = res.getString("world");
                        LinkedList<String> worldParents = (LinkedList<String>)ret.get(world);
                        if (worldParents == null) {
                            worldParents = new LinkedList<String>();
                            ret.put(world, worldParents);
                        }
                        worldParents.add(res.getString("parent"));
                    }
                    if (conn == null) return Collections.unmodifiableMap(ret);
                    if (throwable == null) break block17;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (conn == null) throw throwable3;
                        if (throwable == null) {
                            conn.close();
                            throw throwable3;
                        }
                        try {
                            conn.close();
                            throw throwable3;
                        }
                        catch (Throwable x2) {
                            try {
                                throwable.addSuppressed(x2);
                                throw throwable3;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable3;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return Collections.unmodifiableMap(ret);
                }
                catch (Throwable x2) {
                    try {
                        throwable.addSuppressed(x2);
                        return Collections.unmodifiableMap(ret);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return Collections.unmodifiableMap(ret);
                    }
                }
            }
            conn.close();
            return Collections.unmodifiableMap(ret);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> getParents(String worldName) {
        LinkedList<String> ret = new LinkedList<String>();
        try {
            SQLConnection conn;
            block16: {
                conn = this.backend.getSQL();
                Throwable throwable = null;
                try {
                    ResultSet res = worldName == null ? conn.prepAndBind("SELECT `parent` FROM `{permissions_inheritance}` WHERE `child` = ? AND `type` = ? AND `world` IS NULL ORDER BY `id` DESC", this.getIdentifier(), this.type.ordinal()).executeQuery() : conn.prepAndBind("SELECT `parent` FROM `{permissions_inheritance}` WHERE `child` = ? AND `type` = ? AND `world` = ? ORDER BY `id` DESC", this.getIdentifier(), this.type.ordinal(), worldName).executeQuery();
                    while (res.next()) {
                        ret.add(res.getString("parent"));
                    }
                    if (conn == null) return Collections.unmodifiableList(ret);
                    if (throwable == null) break block16;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (conn == null) throw throwable3;
                        if (throwable == null) {
                            conn.close();
                            throw throwable3;
                        }
                        try {
                            conn.close();
                            throw throwable3;
                        }
                        catch (Throwable x2) {
                            try {
                                throwable.addSuppressed(x2);
                                throw throwable3;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable3;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return Collections.unmodifiableList(ret);
                }
                catch (Throwable x2) {
                    try {
                        throwable.addSuppressed(x2);
                        return Collections.unmodifiableList(ret);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return Collections.unmodifiableList(ret);
                    }
                }
            }
            conn.close();
            return Collections.unmodifiableList(ret);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setParents(List<String> parents, String worldName) {
        if (this.isVirtual()) {
            this.save();
        }
        try {
            SQLConnection conn;
            block19: {
                conn = this.backend.getSQL();
                Throwable throwable = null;
                try {
                    if (worldName != null) {
                        conn.prepAndBind("DELETE FROM `{permissions_inheritance}` WHERE `child` = ? AND `type` = ? AND `world` = ?", this.getIdentifier(), this.type.ordinal(), worldName).execute();
                    } else {
                        conn.prepAndBind("DELETE FROM `{permissions_inheritance}` WHERE `child` = ? AND `type` = ? AND `world` IS NULL", this.getIdentifier(), this.type.ordinal()).execute();
                    }
                    PreparedStatement statement = conn.prepAndBind("INSERT INTO `{permissions_inheritance}` (`child`, `parent`, `type`, `world`) VALUES (?, ?, ?, ?)", this.getIdentifier(), "toset", this.type.ordinal(), worldName);
                    for (int i = parents.size() - 1; i >= 0; --i) {
                        String group = parents.get(i);
                        if (group == null || group.isEmpty()) continue;
                        statement.setString(2, group);
                        statement.addBatch();
                    }
                    statement.executeBatch();
                    if (conn == null) return;
                    if (throwable == null) break block19;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (conn == null) throw throwable3;
                        if (throwable == null) {
                            conn.close();
                            throw throwable3;
                        }
                        try {
                            conn.close();
                            throw throwable3;
                        }
                        catch (Throwable x2) {
                            try {
                                throwable.addSuppressed(x2);
                                throw throwable3;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable3;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return;
                }
                catch (Throwable x2) {
                    try {
                        throwable.addSuppressed(x2);
                        return;
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return;
                    }
                }
            }
            conn.close();
            return;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void load() {
    }

    @Override
    public boolean isDefault(String world) {
        if (world == null) {
            return this.globalDef;
        }
        return Boolean.parseBoolean(this.getOption("default", world));
    }

    @Override
    public void setDefault(boolean def, String world) {
        if (world == null) {
            this.globalDef = def;
            this.updateInfo();
        } else {
            this.setOption("default", world, String.valueOf(def));
        }
    }

    public static Set<String> getEntitiesNames(SQLConnection sql, Type type, boolean defaultOnly) throws SQLException {
        HashSet<String> entities = new HashSet<String>();
        ResultSet result = sql.prepAndBind("SELECT `name` FROM `{permissions_entity}` WHERE `type` = ? " + (defaultOnly ? " AND `default` = 1" : ""), type.ordinal()).executeQuery();
        while (result.next()) {
            entities.add(result.getString("name"));
        }
        result.close();
        return Collections.unmodifiableSet(entities);
    }

    public static enum Type {
        GROUP,
        USER;

    }
}

