/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.backends.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.tehkode.permissions.backends.sql.SQLBackend;

public class SQLConnection
implements AutoCloseable {
    private static final Pattern TABLE_PATTERN = Pattern.compile("\\{([^}]+)\\}");
    private Statement statement;
    private final Connection db;
    private final SQLBackend backend;

    public SQLConnection(Connection conn, SQLBackend backend) {
        this.backend = backend;
        this.db = conn;
    }

    public PreparedStatement prep(String query) throws SQLException {
        return this.db.prepareStatement(this.expandQuery(query));
    }

    public String expandQuery(String query) {
        StringBuffer ret = new StringBuffer();
        Matcher m = TABLE_PATTERN.matcher(query);
        while (m.find()) {
            m.appendReplacement(ret, this.backend.getTableName(m.group(1)));
        }
        m.appendTail(ret);
        return ret.toString();
    }

    public Statement getStatement() throws SQLException {
        this.checkConnection();
        if (this.statement == null) {
            this.statement = this.db.createStatement();
        }
        return this.statement;
    }

    public boolean hasTable(String table) throws SQLException {
        this.checkConnection();
        table = this.expandQuery(table);
        return this.db.getMetaData().getTables(null, null, table, null).next();
    }

    public PreparedStatement prepAndBind(String query, Object ... args) throws SQLException {
        PreparedStatement statement = this.prep(query);
        this.bind(statement, args);
        return statement;
    }

    public PreparedStatement bind(PreparedStatement statement, Object ... args) throws SQLException {
        statement.clearParameters();
        int argsExpected = statement.getParameterMetaData().getParameterCount();
        if (args.length != argsExpected) {
            throw new SQLException("Invalid argument number provided; expected " + argsExpected + " but got " + args.length);
        }
        for (int i = 0; i < args.length; ++i) {
            statement.setObject(i + 1, args[i]);
        }
        return statement;
    }

    protected void checkConnection() throws SQLException {
        if (this.backend.dbDriver.equals("sqlite")) {
            return;
        }
        if (!this.db.isValid(3)) {
            throw new SQLException("Lost connection with database!");
        }
    }

    @Override
    public void close() throws SQLException {
        this.db.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (SQLException e) {
            this.backend.getLogger().log(Level.WARNING, "Error while disconnecting from database: {0}", e.getMessage());
        }
        finally {
            super.finalize();
        }
    }
}

