/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.backends.sql;

import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.bukkit.configuration.ConfigurationSection;
import ru.tehkode.libs.org.apache.commons.dbcp.BasicDataSource;
import ru.tehkode.permissions.PermissionManager;
import ru.tehkode.permissions.PermissionsGroupData;
import ru.tehkode.permissions.PermissionsUserData;
import ru.tehkode.permissions.backends.PermissionBackend;
import ru.tehkode.permissions.backends.caching.CachingGroupData;
import ru.tehkode.permissions.backends.caching.CachingUserData;
import ru.tehkode.permissions.backends.sql.SQLConnection;
import ru.tehkode.permissions.backends.sql.SQLData;
import ru.tehkode.permissions.exceptions.PermissionBackendException;
import ru.tehkode.utils.StringUtils;

public class SQLBackend
extends PermissionBackend {
    protected Map<String, List<String>> worldInheritanceCache;
    private Map<String, Object> tableNames;
    private BasicDataSource ds;
    protected final String dbDriver;
    private final ExecutorService executor;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SQLBackend(PermissionManager manager, ConfigurationSection config) throws PermissionBackendException {
        block18: {
            super(manager, config);
            this.worldInheritanceCache = new HashMap<String, List<String>>();
            String dbUri = this.getConfig().getString("uri", "");
            String dbUser = this.getConfig().getString("user", "");
            String dbPassword = this.getConfig().getString("password", "");
            if (dbUri == null || dbUri.isEmpty()) {
                this.getConfig().set("uri", (Object)"mysql://localhost/exampledb");
                this.getConfig().set("user", (Object)"databaseuser");
                this.getConfig().set("password", (Object)"databasepassword");
                throw new PermissionBackendException("SQL connection is not configured, see config.yml");
            }
            this.dbDriver = dbUri.split(":", 2)[0];
            this.ds = new BasicDataSource();
            String driverClass = SQLBackend.getDriverClass(this.dbDriver);
            if (driverClass != null) {
                this.ds.setDriverClassName(driverClass);
            }
            this.ds.setUrl("jdbc:" + dbUri);
            this.ds.setUsername(dbUser);
            this.ds.setPassword(dbPassword);
            this.ds.setMaxActive(20);
            this.ds.setMaxWait(200L);
            if (this.dbDriver.equals("mysql")) {
                this.ds.addConnectionProperty("autoReconnect", "true");
            }
            try {
                SQLConnection conn;
                block19: {
                    conn = this.getSQL();
                    Throwable throwable = null;
                    try {
                        conn.checkConnection();
                        if (conn == null) break block18;
                        if (throwable == null) break block19;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (conn == null) throw throwable3;
                            if (throwable == null) {
                                conn.close();
                                throw throwable3;
                            }
                            try {
                                conn.close();
                                throw throwable3;
                            }
                            catch (Throwable x2) {
                                try {
                                    throwable.addSuppressed(x2);
                                    throw throwable3;
                                }
                                catch (NoSuchMethodError noSuchMethodError) {
                                    throw throwable3;
                                }
                            }
                        }
                    }
                    try {
                        conn.close();
                    }
                    catch (Throwable x2) {
                        try {
                            throwable.addSuppressed(x2);
                            break block18;
                        }
                        catch (NoSuchMethodError noSuchMethodError) {}
                    }
                    break block18;
                }
                conn.close();
            }
            catch (Exception e) {
                if (e.getCause() == null) throw new PermissionBackendException("Unable to connect to SQL database", e);
                if (!(e.getCause() instanceof Exception)) throw new PermissionBackendException("Unable to connect to SQL database", e);
                e = (Exception)e.getCause();
                throw new PermissionBackendException("Unable to connect to SQL database", e);
            }
        }
        this.getManager().getLogger().info("Successfully connected to SQL database");
        this.executor = Executors.newSingleThreadExecutor();
        this.setupAliases();
        this.deployTables();
    }

    protected static String getDriverClass(String alias) {
        if (alias.equals("mysql")) {
            return "com.mysql.jdbc.Driver";
        }
        if (alias.equals("sqlite")) {
            return "org.sqlite.JDBC";
        }
        if (alias.matches("postgres?")) {
            return "org.postgresql.Driver";
        }
        return null;
    }

    public SQLConnection getSQL() throws SQLException {
        if (this.ds == null) {
            throw new SQLException("SQL connection information was not correct, could not retrieve connection");
        }
        return new SQLConnection(this.ds.getConnection(), this);
    }

    public String getTableName(String identifier) {
        Map<String, Object> tableNames = this.tableNames;
        if (tableNames == null) {
            return identifier;
        }
        Object ret = tableNames.get(identifier);
        if (ret == null) {
            return identifier;
        }
        return ret.toString();
    }

    @Override
    public PermissionsUserData getUserData(String name) {
        return new CachingUserData(new SQLData(name, SQLData.Type.USER, this), this.executor, new Object());
    }

    @Override
    public PermissionsGroupData getGroupData(String name) {
        return new CachingGroupData(new SQLData(name, SQLData.Type.GROUP, this), this.executor, new Object());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasUser(String userName) {
        try {
            boolean bl;
            SQLConnection conn;
            block15: {
                conn = this.getSQL();
                Throwable throwable = null;
                try {
                    ResultSet res = conn.prepAndBind("SELECT `id` FROM `{permissions_entity}` WHERE `type` = ? AND `name` = ?", SQLData.Type.USER.ordinal(), userName).executeQuery();
                    bl = res.next();
                    if (conn == null) return bl;
                    if (throwable == null) break block15;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (conn == null) throw throwable3;
                        if (throwable == null) {
                            conn.close();
                            throw throwable3;
                        }
                        try {
                            conn.close();
                            throw throwable3;
                        }
                        catch (Throwable x2) {
                            try {
                                throwable.addSuppressed(x2);
                                throw throwable3;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable3;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return bl;
                }
                catch (Throwable x2) {
                    try {
                        throwable.addSuppressed(x2);
                        return bl;
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return bl;
                    }
                }
            }
            conn.close();
            return bl;
        }
        catch (SQLException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasGroup(String group) {
        try {
            boolean bl;
            SQLConnection conn;
            block15: {
                conn = this.getSQL();
                Throwable throwable = null;
                try {
                    ResultSet res = conn.prepAndBind("SELECT `id` FROM `{permissions_entity}` WHERE `type` = ? AND `name` = ?", SQLData.Type.GROUP.ordinal(), group).executeQuery();
                    bl = res.next();
                    if (conn == null) return bl;
                    if (throwable == null) break block15;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (conn == null) throw throwable3;
                        if (throwable == null) {
                            conn.close();
                            throw throwable3;
                        }
                        try {
                            conn.close();
                            throw throwable3;
                        }
                        catch (Throwable x2) {
                            try {
                                throwable.addSuppressed(x2);
                                throw throwable3;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable3;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return bl;
                }
                catch (Throwable x2) {
                    try {
                        throwable.addSuppressed(x2);
                        return bl;
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return bl;
                    }
                }
            }
            conn.close();
            return bl;
        }
        catch (SQLException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<String> getDefaultGroupNames(String worldName) {
        try {
            HashSet<String> hashSet;
            SQLConnection conn;
            block16: {
                conn = this.getSQL();
                Throwable throwable = null;
                try {
                    ResultSet result = worldName == null ? conn.prepAndBind("SELECT `name` FROM `{permissions_entity}` WHERE `type` = ? AND `default` = 1", SQLData.Type.GROUP.ordinal()).executeQuery() : conn.prepAndBind("SELECT `name` FROM `{permissions}` WHERE `permission` = 'default' AND `value` = 'true' AND `type` = ? AND `world` = ?", SQLData.Type.GROUP.ordinal(), worldName).executeQuery();
                    HashSet<String> ret = new HashSet<String>();
                    while (result.next()) {
                        ret.add(result.getString("name"));
                    }
                    hashSet = ret;
                    if (conn == null) return hashSet;
                    if (throwable == null) break block16;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (conn == null) throw throwable3;
                        if (throwable == null) {
                            conn.close();
                            throw throwable3;
                        }
                        try {
                            conn.close();
                            throw throwable3;
                        }
                        catch (Throwable x2) {
                            try {
                                throwable.addSuppressed(x2);
                                throw throwable3;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable3;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return hashSet;
                }
                catch (Throwable x2) {
                    try {
                        throwable.addSuppressed(x2);
                        return hashSet;
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return hashSet;
                    }
                }
            }
            conn.close();
            return hashSet;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<String> getGroupNames() {
        try {
            Set<String> set;
            SQLConnection conn;
            block15: {
                conn = this.getSQL();
                Throwable throwable = null;
                try {
                    set = SQLData.getEntitiesNames(conn, SQLData.Type.GROUP, false);
                    if (conn == null) return set;
                    if (throwable == null) break block15;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (conn == null) throw throwable3;
                        if (throwable == null) {
                            conn.close();
                            throw throwable3;
                        }
                        try {
                            conn.close();
                            throw throwable3;
                        }
                        catch (Throwable x2) {
                            try {
                                throwable.addSuppressed(x2);
                                throw throwable3;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable3;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return set;
                }
                catch (Throwable x2) {
                    try {
                        throwable.addSuppressed(x2);
                        return set;
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return set;
                    }
                }
            }
            conn.close();
            return set;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<String> getUserIdentifiers() {
        try {
            Set<String> set;
            SQLConnection conn;
            block15: {
                conn = this.getSQL();
                Throwable throwable = null;
                try {
                    set = SQLData.getEntitiesNames(conn, SQLData.Type.USER, false);
                    if (conn == null) return set;
                    if (throwable == null) break block15;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (conn == null) throw throwable3;
                        if (throwable == null) {
                            conn.close();
                            throw throwable3;
                        }
                        try {
                            conn.close();
                            throw throwable3;
                        }
                        catch (Throwable x2) {
                            try {
                                throwable.addSuppressed(x2);
                                throw throwable3;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable3;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return set;
                }
                catch (Throwable x2) {
                    try {
                        throwable.addSuppressed(x2);
                        return set;
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return set;
                    }
                }
            }
            conn.close();
            return set;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<String> getUserNames() {
        HashSet<String> ret = new HashSet<String>();
        try {
            SQLConnection conn;
            block16: {
                conn = this.getSQL();
                Throwable throwable = null;
                try {
                    ResultSet set = conn.prepAndBind("SELECT `value` FROM `{permissions}` WHERE `type` = ? AND `name` = 'name' AND `value` IS NOT NULL", SQLData.Type.USER.ordinal()).executeQuery();
                    while (set.next()) {
                        ret.add(set.getString("value"));
                    }
                    if (conn == null) return Collections.unmodifiableSet(ret);
                    if (throwable == null) break block16;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (conn == null) throw throwable3;
                        if (throwable == null) {
                            conn.close();
                            throw throwable3;
                        }
                        try {
                            conn.close();
                            throw throwable3;
                        }
                        catch (Throwable x2) {
                            try {
                                throwable.addSuppressed(x2);
                                throw throwable3;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable3;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return Collections.unmodifiableSet(ret);
                }
                catch (Throwable x2) {
                    try {
                        throwable.addSuppressed(x2);
                        return Collections.unmodifiableSet(ret);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return Collections.unmodifiableSet(ret);
                    }
                }
            }
            conn.close();
            return Collections.unmodifiableSet(ret);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void setupAliases() {
        ConfigurationSection aliases = this.getConfig().getConfigurationSection("aliases");
        if (aliases == null) {
            return;
        }
        this.tableNames = aliases.getValues(false);
    }

    private void executeStream(SQLConnection conn, InputStream str) throws SQLException, IOException {
        String deploySQL = StringUtils.readStream(str);
        Statement s = conn.getStatement();
        for (String sqlQuery : deploySQL.trim().split(";")) {
            if ((sqlQuery = sqlQuery.trim()).isEmpty()) continue;
            sqlQuery = conn.expandQuery(sqlQuery + ";");
            s.addBatch(sqlQuery);
        }
        s.executeBatch();
    }

    /*
     * Loose catch block
     */
    protected final void deployTables() throws PermissionBackendException {
        block26: {
            try {
                Throwable throwable;
                SQLConnection conn;
                block27: {
                    block23: {
                        block24: {
                            block25: {
                                conn = this.getSQL();
                                throwable = null;
                                if (!conn.hasTable("{permissions}")) break block23;
                                if (conn == null) break block24;
                                if (throwable == null) break block25;
                                try {
                                    conn.close();
                                }
                                catch (Throwable x2) {
                                    try {
                                        throwable.addSuppressed(x2);
                                        break block24;
                                    }
                                    catch (NoSuchMethodError noSuchMethodError) {}
                                }
                                break block24;
                            }
                            conn.close();
                        }
                        return;
                    }
                    InputStream databaseDumpStream = this.getClass().getResourceAsStream("/sql/" + this.dbDriver + ".sql");
                    if (databaseDumpStream == null) {
                        throw new Exception("Can't find appropriate database dump for used database (" + this.dbDriver + "). Is it bundled?");
                    }
                    this.getLogger().info("Deploying default database scheme");
                    this.executeStream(conn, databaseDumpStream);
                    if (conn == null) break block26;
                    if (throwable == null) break block27;
                    try {
                        conn.close();
                    }
                    catch (Throwable x2) {
                        try {
                            throwable.addSuppressed(x2);
                            break block26;
                        }
                        catch (NoSuchMethodError noSuchMethodError) {}
                    }
                    break block26;
                }
                conn.close();
                break block26;
                catch (Throwable throwable2) {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (conn != null) {
                            if (throwable != null) {
                                try {
                                    conn.close();
                                }
                                catch (Throwable x2) {
                                    try {
                                        throwable.addSuppressed(x2);
                                    }
                                    catch (NoSuchMethodError noSuchMethodError) {}
                                }
                            } else {
                                conn.close();
                            }
                        }
                        throw throwable3;
                    }
                }
            }
            catch (Exception e) {
                throw new PermissionBackendException("Deploying of default data failed. Please initialize database manually using " + this.dbDriver + ".sql", e);
            }
        }
        PermissionsGroupData defGroup = this.getGroupData("default");
        defGroup.setPermissions(Collections.singletonList("modifyworld.*"), null);
        defGroup.setDefault(true, null);
        defGroup.save();
        this.getLogger().info("Database scheme deploying complete.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> getWorldInheritance(String world) {
        if (world == null) return Collections.emptyList();
        if (world.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.worldInheritanceCache.containsKey(world)) return this.worldInheritanceCache.get(world);
        try {
            SQLConnection conn;
            block17: {
                conn = this.getSQL();
                Throwable throwable = null;
                try {
                    ResultSet result = conn.prepAndBind("SELECT `parent` FROM `{permissions_inheritance}` WHERE `child` = ? AND `type` = 2;", world).executeQuery();
                    LinkedList<String> worldParents = new LinkedList<String>();
                    while (result.next()) {
                        worldParents.add(result.getString("parent"));
                    }
                    this.worldInheritanceCache.put(world, Collections.unmodifiableList(worldParents));
                    if (conn == null) return this.worldInheritanceCache.get(world);
                    if (throwable == null) break block17;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (conn == null) throw throwable3;
                        if (throwable == null) {
                            conn.close();
                            throw throwable3;
                        }
                        try {
                            conn.close();
                            throw throwable3;
                        }
                        catch (Throwable x2) {
                            try {
                                throwable.addSuppressed(x2);
                                throw throwable3;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable3;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return this.worldInheritanceCache.get(world);
                }
                catch (Throwable x2) {
                    try {
                        throwable.addSuppressed(x2);
                        return this.worldInheritanceCache.get(world);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return this.worldInheritanceCache.get(world);
                    }
                }
            }
            conn.close();
            return this.worldInheritanceCache.get(world);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, List<String>> getAllWorldInheritance() {
        try {
            Map<String, List<String>> map;
            SQLConnection conn;
            block16: {
                conn = this.getSQL();
                Throwable throwable = null;
                try {
                    ResultSet result = conn.prepAndBind("SELECT `child` FROM `{permissions_inheritance}` WHERE `type` = 2 ", new Object[0]).executeQuery();
                    HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
                    while (result.next()) {
                        String world = result.getString("child");
                        if (ret.containsKey(world)) continue;
                        ret.put(world, this.getWorldInheritance(world));
                    }
                    map = Collections.unmodifiableMap(ret);
                    if (conn == null) return map;
                    if (throwable == null) break block16;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (conn == null) throw throwable3;
                        if (throwable == null) {
                            conn.close();
                            throw throwable3;
                        }
                        try {
                            conn.close();
                            throw throwable3;
                        }
                        catch (Throwable x2) {
                            try {
                                throwable.addSuppressed(x2);
                                throw throwable3;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable3;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return map;
                }
                catch (Throwable x2) {
                    try {
                        throwable.addSuppressed(x2);
                        return map;
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return map;
                    }
                }
            }
            conn.close();
            return map;
        }
        catch (SQLException e) {
            return Collections.unmodifiableMap(this.worldInheritanceCache);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setWorldInheritance(String worldName, List<String> parentWorlds) {
        if (worldName == null) return;
        if (worldName.isEmpty()) {
            return;
        }
        try {
            SQLConnection conn;
            block17: {
                conn = this.getSQL();
                Throwable throwable = null;
                try {
                    conn.prepAndBind("DELETE FROM `{permissions_inheritance}` WHERE `child` = ? AND `type` = 2", worldName).execute();
                    PreparedStatement statement = conn.prepAndBind("INSERT INTO `{permissions_inheritance}` (`child`, `parent`, `type`) VALUES (?, ?, 2)", worldName, "toset");
                    for (String parentWorld : parentWorlds) {
                        statement.setString(2, parentWorld);
                        statement.addBatch();
                    }
                    statement.executeBatch();
                    this.worldInheritanceCache.put(worldName, parentWorlds);
                    if (conn == null) return;
                    if (throwable == null) break block17;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (conn == null) throw throwable3;
                        if (throwable == null) {
                            conn.close();
                            throw throwable3;
                        }
                        try {
                            conn.close();
                            throw throwable3;
                        }
                        catch (Throwable x2) {
                            try {
                                throwable.addSuppressed(x2);
                                throw throwable3;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable3;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return;
                }
                catch (Throwable x2) {
                    try {
                        throwable.addSuppressed(x2);
                        return;
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return;
                    }
                }
            }
            conn.close();
            return;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void reload() {
        this.worldInheritanceCache.clear();
    }

    @Override
    public void close() throws PermissionBackendException {
        this.executor.shutdown();
        if (this.ds != null) {
            try {
                this.ds.close();
            }
            catch (SQLException e) {
                throw new PermissionBackendException("Error while closing", e);
            }
        }
        try {
            this.executor.awaitTermination(200L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new PermissionBackendException(e);
        }
    }
}

