/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.backends.memory;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.tehkode.permissions.PermissionsGroupData;
import ru.tehkode.permissions.PermissionsUserData;

public class MemoryData
implements PermissionsGroupData,
PermissionsUserData {
    private String name;
    private final HashMap<String, String> worldPrefix = new HashMap();
    private final HashMap<String, String> worldSuffix = new HashMap();
    private final HashMap<String, List<String>> worldsPermissions = new HashMap();
    private final Map<String, Map<String, String>> worldsOptions = new HashMap<String, Map<String, String>>();
    private final Map<String, List<String>> parents = new HashMap<String, List<String>>();
    private final Map<String, Boolean> defaultVals = new HashMap<String, Boolean>();

    public MemoryData(String name) {
        this.name = name;
    }

    @Override
    public List<String> getParents(String worldName) {
        return this.parents.containsKey(worldName) ? this.parents.get(worldName) : Collections.emptyList();
    }

    @Override
    public void setParents(List<String> parents, String worldName) {
        this.parents.put(worldName, Collections.unmodifiableList(parents));
    }

    @Override
    public void load() {
    }

    @Override
    public boolean isDefault(String world) {
        return this.defaultVals.containsKey(world) ? this.defaultVals.get(world) : false;
    }

    @Override
    public void setDefault(boolean def, String world) {
        this.defaultVals.put(world, def);
    }

    @Override
    public String getIdentifier() {
        return this.name;
    }

    @Override
    public List<String> getPermissions(String worldName) {
        return this.worldsPermissions.containsKey(worldName) ? this.worldsPermissions.get(worldName) : Collections.emptyList();
    }

    @Override
    public void setPermissions(List<String> permissions, String worldName) {
        this.worldsPermissions.put(worldName, Collections.unmodifiableList(permissions));
    }

    @Override
    public Map<String, List<String>> getPermissionsMap() {
        return Collections.unmodifiableMap(this.worldsPermissions);
    }

    @Override
    public Set<String> getWorlds() {
        return Sets.union(this.worldsOptions.keySet(), this.worldPrefix.keySet());
    }

    @Override
    public String getOption(String option, String worldName) {
        Map<String, String> worldOption;
        if (this.worldsOptions.containsKey(worldName) && (worldOption = this.worldsOptions.get(worldName)).containsKey(option)) {
            return worldOption.get(option);
        }
        return null;
    }

    @Override
    public void setOption(String option, String worldName, String value) {
        Map<String, String> worldOptions = this.worldsOptions.get(worldName);
        if (worldOptions == null) {
            worldOptions = new HashMap<String, String>();
            this.worldsOptions.put(worldName, worldOptions);
        }
        worldOptions.put(option, value);
    }

    @Override
    public Map<String, String> getOptions(String worldName) {
        return this.worldsOptions.containsKey(worldName) ? this.worldsOptions.get(worldName) : Collections.emptyMap();
    }

    @Override
    public Map<String, Map<String, String>> getOptionsMap() {
        return Collections.unmodifiableMap(this.worldsOptions);
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    @Override
    public void save() {
    }

    @Override
    public void remove() {
    }

    @Override
    public Map<String, List<String>> getParentsMap() {
        return Collections.unmodifiableMap(this.parents);
    }

    @Override
    public boolean setIdentifier(String identifier) {
        this.name = identifier;
        return true;
    }
}

