/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.backends.file;

import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class FileConfig
extends YamlConfiguration {
    private final File file;
    private final File tempFile;
    private final File oldFile;
    private final Object lock;
    private boolean saveSuppressed;

    public FileConfig(File file) {
        this(file, new Object());
    }

    public FileConfig(File file, Object lock) {
        this.lock = lock;
        this.options().pathSeparator('/');
        this.file = file;
        this.tempFile = new File(file.getPath() + ".tmp");
        this.oldFile = new File(file.getPath() + ".old");
    }

    public File getFile() {
        return this.file;
    }

    public void load() throws IOException, InvalidConfigurationException {
        this.load(this.file);
    }

    public void save() throws IOException {
        if (!this.saveSuppressed) {
            this.save(this.tempFile);
            this.oldFile.delete();
            if (!this.file.exists() || this.file.renameTo(this.oldFile)) {
                if (!this.tempFile.renameTo(this.file)) {
                    throw new IOException("Unable to overwrite config with temporary file! New config is at " + this.tempFile + ", old config at" + this.oldFile);
                }
                if (!this.oldFile.delete()) {
                    throw new IOException("Unable to delete old file " + this.oldFile);
                }
            }
        }
    }

    public boolean isSaveSuppressed() {
        return this.saveSuppressed;
    }

    void setSaveSuppressed(boolean saveSuppressed) {
        this.saveSuppressed = saveSuppressed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromString(String contents) throws InvalidConfigurationException {
        Object object = this.lock;
        synchronized (object) {
            super.loadFromString(contents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String saveToString() {
        Object object = this.lock;
        synchronized (object) {
            return super.saveToString();
        }
    }
}

