/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.backends.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.bukkit.configuration.ConfigurationSection;
import ru.tehkode.permissions.PermissionManager;
import ru.tehkode.permissions.PermissionsGroupData;
import ru.tehkode.permissions.PermissionsUserData;
import ru.tehkode.permissions.backends.PermissionBackend;
import ru.tehkode.permissions.backends.caching.CachingGroupData;
import ru.tehkode.permissions.backends.caching.CachingUserData;
import ru.tehkode.permissions.backends.file.FileConfig;
import ru.tehkode.permissions.backends.file.FileData;
import ru.tehkode.permissions.exceptions.PermissionBackendException;

public class FileBackend
extends PermissionBackend {
    public static final char PATH_SEPARATOR = '/';
    public FileConfig permissions;
    public File permissionsFile;
    private final ExecutorService executor;
    private final Object lock = new Object();

    public FileBackend(PermissionManager manager, ConfigurationSection config) throws PermissionBackendException {
        super(manager, config);
        File baseDirectory;
        String baseDir;
        this.executor = Executors.newSingleThreadExecutor();
        String permissionFilename = this.getConfig().getString("file");
        if (permissionFilename == null) {
            permissionFilename = "permissions.yml";
            this.getConfig().set("file", (Object)"permissions.yml");
        }
        if ((baseDir = manager.getPlugin().getConfig().getString("permissions.basedir", manager.getPlugin().getDataFolder().getPath())).contains("\\") && !"\\".equals(File.separator)) {
            baseDir = baseDir.replace("\\", File.separator);
        }
        if (!(baseDirectory = new File(baseDir)).exists()) {
            baseDirectory.mkdirs();
        }
        this.permissionsFile = new File(baseDir, permissionFilename);
        this.reload();
    }

    @Override
    public List<String> getWorldInheritance(String world) {
        List parentWorlds;
        if (world != null && !world.isEmpty() && (parentWorlds = this.permissions.getStringList(FileBackend.buildPath("worlds", world, "/inheritance"))) != null) {
            return Collections.unmodifiableList(parentWorlds);
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, List<String>> getAllWorldInheritance() {
        ConfigurationSection worldsSection = this.permissions.getConfigurationSection("worlds");
        if (worldsSection == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        for (String world : worldsSection.getKeys(false)) {
            ret.put(world, this.getWorldInheritance(world));
        }
        return Collections.unmodifiableMap(ret);
    }

    @Override
    public void setWorldInheritance(String world, List<String> parentWorlds) {
        if (world == null || world.isEmpty()) {
            return;
        }
        this.permissions.set(FileBackend.buildPath("worlds", world, "inheritance"), parentWorlds);
        this.save();
    }

    @Override
    public PermissionsUserData getUserData(String userName) {
        CachingUserData data = new CachingUserData(new FileData("users", userName, this.permissions, "group"), this.executor, this.lock);
        data.load();
        return data;
    }

    @Override
    public PermissionsGroupData getGroupData(String groupName) {
        CachingGroupData data = new CachingGroupData(new FileData("groups", groupName, this.permissions, "inheritance"), this.executor, this.lock);
        data.load();
        return data;
    }

    @Override
    public boolean hasUser(String userName) {
        if (this.permissions.isConfigurationSection(FileBackend.buildPath("users", userName))) {
            return true;
        }
        ConfigurationSection userSection = this.permissions.getConfigurationSection("users");
        if (userSection != null) {
            for (String name : userSection.getKeys(false)) {
                if (!userName.equalsIgnoreCase(name)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasGroup(String group) {
        if (this.permissions.isConfigurationSection(FileBackend.buildPath("groups", group))) {
            return true;
        }
        ConfigurationSection userSection = this.permissions.getConfigurationSection("groups");
        if (userSection != null) {
            for (String name : userSection.getKeys(false)) {
                if (!group.equalsIgnoreCase(name)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<String> getDefaultGroupNames(String worldName) {
        ConfigurationSection groups = this.permissions.getConfigurationSection("groups");
        if (groups == null) {
            return Collections.emptySet();
        }
        HashSet names = new HashSet();
        String defaultGroupProperty = "default";
        if (worldName != null) {
            defaultGroupProperty = FileBackend.buildPath("worlds", worldName, defaultGroupProperty);
        }
        for (Map.Entry entry : groups.getValues(false).entrySet()) {
            ConfigurationSection groupSection;
            if (!(entry.getValue() instanceof ConfigurationSection) || !(groupSection = (ConfigurationSection)entry.getValue()).getBoolean(defaultGroupProperty, false)) continue;
            names.add(entry.getKey());
        }
        return Collections.unmodifiableSet(names);
    }

    @Override
    public Collection<String> getUserIdentifiers() {
        ConfigurationSection users = this.permissions.getConfigurationSection("users");
        return users != null ? users.getKeys(false) : Collections.emptyList();
    }

    @Override
    public Collection<String> getUserNames() {
        ConfigurationSection users = this.permissions.getConfigurationSection("users");
        if (users == null) {
            return Collections.emptySet();
        }
        HashSet<String> userNames = new HashSet<String>();
        for (Map.Entry entry : users.getValues(false).entrySet()) {
            if (!(entry.getValue() instanceof ConfigurationSection)) continue;
            ConfigurationSection userSection = (ConfigurationSection)entry.getValue();
            String name = userSection.getString(FileBackend.buildPath("options", "name"));
            if (name == null) continue;
            userNames.add(name);
        }
        return Collections.unmodifiableSet(userNames);
    }

    @Override
    public Collection<String> getGroupNames() {
        ConfigurationSection groups = this.permissions.getConfigurationSection("groups");
        return groups != null ? groups.getKeys(false) : Collections.emptySet();
    }

    public static String buildPath(String ... path) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        char separator = '/';
        for (String node : path) {
            if (node.isEmpty()) continue;
            if (!first) {
                builder.append(separator);
            }
            builder.append(node);
            first = false;
        }
        return builder.toString();
    }

    @Override
    public void reload() throws PermissionBackendException {
        FileConfig newPermissions = new FileConfig(this.permissionsFile);
        newPermissions.options().pathSeparator('/');
        try {
            newPermissions.load();
            this.getLogger().info("Permissions file successfully reloaded");
            this.permissions = newPermissions;
        }
        catch (FileNotFoundException e) {
            if (this.permissions == null) {
                this.permissions = newPermissions;
                this.initNewConfiguration();
            }
        }
        catch (Throwable e) {
            throw new PermissionBackendException("Error loading permissions file!", e);
        }
    }

    private void initNewConfiguration() throws PermissionBackendException {
        if (!this.permissionsFile.exists()) {
            try {
                this.permissionsFile.createNewFile();
                this.permissions.set("groups/default/default", true);
                LinkedList<String> defaultPermissions = new LinkedList<String>();
                defaultPermissions.add("modifyworld.*");
                this.permissions.set("groups/default/permissions", defaultPermissions);
                this.save();
            }
            catch (IOException e) {
                throw new PermissionBackendException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadFrom(PermissionBackend backend) {
        boolean oldSaveSuppr = this.permissions.isSaveSuppressed();
        this.permissions.setSaveSuppressed(true);
        try {
            super.loadFrom(backend);
        }
        finally {
            this.permissions.setSaveSuppressed(oldSaveSuppr);
        }
        this.save();
    }

    @Override
    public void close() throws PermissionBackendException {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new PermissionBackendException(e);
        }
    }

    @Override
    public void setPersistent(boolean persistent) {
        this.permissions.setSaveSuppressed(!persistent);
        if (persistent) {
            this.save();
        }
    }

    public void save() {
        try {
            this.permissions.save();
        }
        catch (IOException e) {
            this.getManager().getLogger().severe("Error while saving permissions file: " + e.getMessage());
        }
    }
}

