/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.backends.caching;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import ru.tehkode.permissions.PermissionsGroupData;
import ru.tehkode.permissions.backends.caching.CachingData;

public class CachingGroupData
extends CachingData
implements PermissionsGroupData {
    private final PermissionsGroupData backingData;
    private final Map<String, Boolean> defaultsMap = new HashMap<String, Boolean>();

    public CachingGroupData(PermissionsGroupData backingData, Executor executor, Object lock) {
        super(executor, lock);
        this.backingData = backingData;
    }

    @Override
    protected PermissionsGroupData getBackingData() {
        return this.backingData;
    }

    @Override
    protected void clearCache() {
        super.clearCache();
        this.defaultsMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDefault(String world) {
        Boolean bool = this.defaultsMap.get(world);
        if (bool == null) {
            Object object = this.lock;
            synchronized (object) {
                bool = this.getBackingData().isDefault(world);
            }
            this.defaultsMap.put(world, bool);
        }
        return bool;
    }

    @Override
    public void setDefault(final boolean def, final String world) {
        this.defaultsMap.put(world, def);
        this.execute(new Runnable(){

            @Override
            public void run() {
                CachingGroupData.this.getBackingData().setDefault(def, world);
            }
        });
    }
}

