/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.backends;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import ru.tehkode.permissions.PermissionManager;
import ru.tehkode.permissions.PermissionsGroupData;
import ru.tehkode.permissions.PermissionsUserData;
import ru.tehkode.permissions.backends.BackendDataTransfer;
import ru.tehkode.permissions.bukkit.PermissionsEx;
import ru.tehkode.permissions.exceptions.PermissionBackendException;

public abstract class PermissionBackend {
    private final PermissionManager manager;
    private final ConfigurationSection backendConfig;
    private boolean persistent;
    public static final String DEFAULT_BACKEND = "file";
    private static final Map<String, Class<? extends PermissionBackend>> REGISTERED_ALIASES = new HashMap<String, Class<? extends PermissionBackend>>();

    protected PermissionBackend(PermissionManager manager, ConfigurationSection backendConfig) throws PermissionBackendException {
        this.manager = manager;
        this.backendConfig = backendConfig;
    }

    protected final PermissionManager getManager() {
        return this.manager;
    }

    protected final ConfigurationSection getConfig() {
        return this.backendConfig;
    }

    public abstract void reload() throws PermissionBackendException;

    public abstract PermissionsUserData getUserData(String var1);

    public abstract PermissionsGroupData getGroupData(String var1);

    public abstract boolean hasUser(String var1);

    public abstract boolean hasGroup(String var1);

    public abstract Collection<String> getUserIdentifiers();

    public abstract Collection<String> getUserNames();

    public abstract Collection<String> getGroupNames();

    public abstract Set<String> getDefaultGroupNames(String var1);

    public abstract List<String> getWorldInheritance(String var1);

    public abstract Map<String, List<String>> getAllWorldInheritance();

    public abstract void setWorldInheritance(String var1, List<String> var2);

    public void close() throws PermissionBackendException {
    }

    public final Logger getLogger() {
        return this.manager.getLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFrom(PermissionBackend backend) {
        this.setPersistent(false);
        try {
            for (String string : backend.getGroupNames()) {
                BackendDataTransfer.transferGroup(backend.getGroupData(string), this.getGroupData(string));
            }
            for (String string : backend.getUserIdentifiers()) {
                BackendDataTransfer.transferUser(backend.getUserData(string), this.getUserData(string));
            }
            for (Map.Entry entry : backend.getAllWorldInheritance().entrySet()) {
                this.setWorldInheritance((String)entry.getKey(), (List)entry.getValue());
            }
        }
        finally {
            this.setPersistent(true);
        }
    }

    public void setPersistent(boolean persistent) {
    }

    public static String getBackendClassName(String alias) {
        if (REGISTERED_ALIASES.containsKey(alias)) {
            return REGISTERED_ALIASES.get(alias).getName();
        }
        return alias;
    }

    public static Class<? extends PermissionBackend> getBackendClass(String alias) throws ClassNotFoundException {
        if (!REGISTERED_ALIASES.containsKey(alias)) {
            Class<?> clazz = Class.forName(alias);
            if (!PermissionBackend.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Provided class " + alias + " is not a subclass of PermissionBackend!");
            }
            return clazz.asSubclass(PermissionBackend.class);
        }
        return REGISTERED_ALIASES.get(alias);
    }

    public static void registerBackendAlias(String alias, Class<? extends PermissionBackend> backendClass) {
        if (!PermissionBackend.class.isAssignableFrom(backendClass)) {
            throw new IllegalArgumentException("Provided class should be subclass of PermissionBackend");
        }
        REGISTERED_ALIASES.put(alias, backendClass);
    }

    public static String getBackendAlias(Class<? extends PermissionBackend> backendClass) {
        if (REGISTERED_ALIASES.containsValue(backendClass)) {
            for (String alias : REGISTERED_ALIASES.keySet()) {
                if (!REGISTERED_ALIASES.get(alias).equals(backendClass)) continue;
                return alias;
            }
        }
        return backendClass.getName();
    }

    public static PermissionBackend getBackend(String backendName, Configuration config) throws PermissionBackendException {
        return PermissionBackend.getBackend(backendName, PermissionsEx.getPermissionManager(), (ConfigurationSection)config, DEFAULT_BACKEND);
    }

    public static PermissionBackend getBackend(String backendName, PermissionManager manager, ConfigurationSection config) throws PermissionBackendException {
        return PermissionBackend.getBackend(backendName, manager, config, DEFAULT_BACKEND);
    }

    public static PermissionBackend getBackend(String backendName, PermissionManager manager, ConfigurationSection config, String fallBackBackend) throws PermissionBackendException {
        if (backendName == null || backendName.isEmpty()) {
            backendName = DEFAULT_BACKEND;
        }
        String className = PermissionBackend.getBackendClassName(backendName);
        try {
            Class<? extends PermissionBackend> backendClass = PermissionBackend.getBackendClass(backendName);
            manager.getLogger().info("Initializing " + backendName + " backend");
            Constructor<? extends PermissionBackend> constructor = backendClass.getConstructor(PermissionManager.class, ConfigurationSection.class);
            return constructor.newInstance(manager, config);
        }
        catch (ClassNotFoundException e) {
            manager.getLogger().warning("Specified backend \"" + backendName + "\" is unknown.");
            if (fallBackBackend == null) {
                throw new RuntimeException(e);
            }
            if (!className.equals(PermissionBackend.getBackendClassName(fallBackBackend))) {
                return PermissionBackend.getBackend(fallBackBackend, manager, config, null);
            }
            throw new RuntimeException(e);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException && (e = e.getCause()) instanceof PermissionBackendException) {
                throw (PermissionBackendException)e;
            }
            throw new RuntimeException(e);
        }
    }
}

