/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.backends;

import java.util.List;
import java.util.Map;
import ru.tehkode.permissions.PermissionsData;
import ru.tehkode.permissions.PermissionsGroupData;
import ru.tehkode.permissions.PermissionsUserData;

public class BackendDataTransfer {
    private BackendDataTransfer() {
    }

    private static void transferBase(PermissionsData from, PermissionsData to) {
        for (Map.Entry<String, List<String>> entry : from.getPermissionsMap().entrySet()) {
            to.setPermissions(entry.getValue(), entry.getKey());
        }
        for (Map.Entry<String, Object> entry : from.getOptionsMap().entrySet()) {
            for (Map.Entry option : ((Map)entry.getValue()).entrySet()) {
                to.setOption((String)option.getKey(), (String)option.getValue(), entry.getKey());
            }
        }
        to.setParents(from.getParents(null), null);
        for (String string : from.getWorlds()) {
            List<String> groups = from.getParents(string);
            if (groups == null || groups.isEmpty()) continue;
            to.setParents(groups, string);
        }
    }

    public static void transferGroup(PermissionsGroupData from, PermissionsGroupData to) {
        BackendDataTransfer.transferBase(from, to);
        to.setDefault(from.isDefault(null), null);
        for (String world : from.getWorlds()) {
            to.setDefault(from.isDefault(world), world);
        }
    }

    public static void transferUser(PermissionsUserData from, PermissionsUserData to) {
        BackendDataTransfer.transferBase(from, to);
    }
}

