/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import ru.tehkode.permissions.PermissionMatcher;
import ru.tehkode.permissions.bukkit.ErrorReport;

public class RegExpMatcher
implements PermissionMatcher {
    public static final String RAW_REGEX_CHAR = "$";
    protected static Pattern rangeExpression = Pattern.compile("(\\d+)-(\\d+)");
    private final Cache<String, Pattern> patternCache = CacheBuilder.newBuilder().maximumSize(500).build((CacheLoader)new CacheLoader<String, Pattern>(){

        public Pattern load(String permission) throws Exception {
            return RegExpMatcher.createPattern(permission);
        }
    });

    @Override
    public boolean isMatches(String expression, String permission) {
        try {
            Pattern permissionMatcher = (Pattern)this.patternCache.get((Object)expression);
            return permissionMatcher.matcher(permission).matches();
        }
        catch (ExecutionException e) {
            ErrorReport.handleError("While checking for regex match for " + permission + " against expression " + expression, e);
            return false;
        }
    }

    protected static Pattern createPattern(String expression) {
        try {
            return Pattern.compile(RegExpMatcher.prepareRegexp(expression), 2);
        }
        catch (PatternSyntaxException e) {
            return Pattern.compile(Pattern.quote(expression), 2);
        }
    }

    public static String prepareRegexp(String expression) {
        boolean rawRegexp;
        if (expression.startsWith("-")) {
            expression = expression.substring(1);
        }
        if (expression.startsWith("#")) {
            expression = expression.substring(1);
        }
        if (rawRegexp = expression.startsWith(RAW_REGEX_CHAR)) {
            expression = expression.substring(1);
        }
        String regexp = rawRegexp ? expression : expression.replace(".", "\\.").replace("*", "(.*)");
        return regexp;
    }
}

