/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions;

import com.zachsthings.netevents.NetEventsPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import ru.tehkode.permissions.PermissionGroup;
import ru.tehkode.permissions.PermissionMatcher;
import ru.tehkode.permissions.PermissionUser;
import ru.tehkode.permissions.PermissionsGroupData;
import ru.tehkode.permissions.PermissionsUserData;
import ru.tehkode.permissions.RegExpMatcher;
import ru.tehkode.permissions.backends.PermissionBackend;
import ru.tehkode.permissions.bukkit.PermissionsEx;
import ru.tehkode.permissions.events.PermissionEntityEvent;
import ru.tehkode.permissions.events.PermissionEvent;
import ru.tehkode.permissions.events.PermissionSystemEvent;
import ru.tehkode.permissions.exceptions.PermissionBackendException;

public class PermissionManager {
    public static final int TRANSIENT_PERMISSION = 0;
    protected Map<String, PermissionUser> users = new HashMap<String, PermissionUser>();
    protected Map<String, PermissionGroup> groups = new HashMap<String, PermissionGroup>();
    protected Map<String, PermissionGroup> defaultGroups = new HashMap<String, PermissionGroup>();
    protected PermissionBackend backend = null;
    private final PermissionsEx plugin;
    protected Timer timer;
    protected boolean debugMode = false;
    protected boolean allowOps = false;
    protected boolean userAddGroupsLast = false;
    private NetEventsPlugin netEvents;
    protected PermissionMatcher matcher = new RegExpMatcher();

    public PermissionManager(PermissionsEx plugin) throws PermissionBackendException {
        Plugin netEventsPlugin;
        this.plugin = plugin;
        if (plugin.getConfiguration().useNetEvents() && (netEventsPlugin = plugin.getServer().getPluginManager().getPlugin("NetEvents")) != null && netEventsPlugin.isEnabled()) {
            this.netEvents = (NetEventsPlugin)netEventsPlugin;
            plugin.getServer().getPluginManager().registerEvents((Listener)new RemoteEventListener(), (Plugin)plugin);
        }
        this.debugMode = plugin.getConfiguration().isDebug();
        this.allowOps = plugin.getConfiguration().allowOps();
        this.userAddGroupsLast = plugin.getConfiguration().userAddGroupsLast();
        this.initBackend();
    }

    UUID getServerUUID() {
        return this.netEvents != null ? this.netEvents.getServerUUID() : null;
    }

    public boolean isLocal(PermissionEvent event) {
        return this.netEvents == null || event.getSourceUUID().equals(this.netEvents.getServerUUID());
    }

    public boolean shouldCreateUserRecords() {
        return this.plugin.getConfiguration().createUserRecords();
    }

    public PermissionsEx getPlugin() {
        return this.plugin;
    }

    public boolean has(Player player, String permission) {
        return this.has(player.getUniqueId(), permission, player.getWorld().getName());
    }

    public boolean has(Player player, String permission, String world) {
        return this.has(player.getUniqueId(), permission, world);
    }

    public boolean has(String playerName, String permission, String world) {
        PermissionUser user = this.getUser(playerName);
        if (user == null) {
            return false;
        }
        return user.has(permission, world);
    }

    public boolean has(UUID playerId, String permission, String world) {
        PermissionUser user = this.getUser(playerId);
        return user != null && user.has(permission, world);
    }

    public PermissionUser getUser(String username) {
        if (username == null || username.isEmpty()) {
            throw new IllegalArgumentException("Null or empty name passed! Name must not be empty");
        }
        try {
            if (username.length() != 36) {
                throw new IllegalArgumentException("not a uuid, try stuff");
            }
            return this.getUser(UUID.fromString(username));
        }
        catch (IllegalArgumentException ex) {
            OfflinePlayer player = this.plugin.getServer().getOfflinePlayer(username);
            UUID userUUID = null;
            try {
                userUUID = player instanceof Player ? ((Player)player).getUniqueId() : player.getUniqueId();
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (userUUID != null && (player.isOnline() || this.backend.hasUser(userUUID.toString()))) {
                return this.getUser(userUUID.toString(), username, player.isOnline());
            }
            return this.getUser(username, null, player.isOnline());
        }
    }

    public PermissionUser getUser(Player player) {
        return this.getUser(player.getUniqueId().toString(), player.getName(), true);
    }

    public PermissionUser getUser(UUID uid) {
        String identifier = uid.toString();
        if (this.users.containsKey(identifier.toLowerCase())) {
            return this.getUser(identifier, null, false);
        }
        Player ply = null;
        try {
            ply = this.plugin.getServer().getPlayer(uid);
        }
        catch (NoSuchMethodError e) {
            // empty catch block
        }
        String fallbackName = null;
        if (ply != null) {
            fallbackName = ply.getName();
        }
        return this.getUser(identifier, fallbackName, ply != null);
    }

    private PermissionUser getUser(String identifier, String fallbackName, boolean store) {
        PermissionUser user = this.users.get(identifier.toLowerCase());
        if (user != null) {
            return user;
        }
        PermissionsUserData data = this.backend.getUserData(identifier);
        if (data != null) {
            if (fallbackName != null && data.isVirtual() && this.backend.hasUser(fallbackName)) {
                PermissionsUserData oldData;
                if (this.isDebug()) {
                    this.getLogger().info("Converting user " + fallbackName + " (UUID " + identifier + ") to UUID-based storage");
                }
                if ((oldData = this.backend.getUserData(fallbackName)).setIdentifier(identifier)) {
                    data = oldData;
                    data.setOption("name", fallbackName, null);
                    this.resetUser(fallbackName);
                } else {
                    throw new IllegalStateException("User already exists with new id " + identifier + " (converting from " + fallbackName + ")");
                }
            }
            user = new PermissionUser(identifier, data, this);
            user.initialize();
            if (store) {
                this.users.put(identifier.toLowerCase(), user);
            }
        } else {
            throw new IllegalStateException("User " + identifier + " is null");
        }
        return user;
    }

    public Set<PermissionUser> getUsers() {
        HashSet<PermissionUser> users = new HashSet<PermissionUser>();
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            users.add(this.getUser(p));
        }
        for (String name : this.backend.getUserIdentifiers()) {
            users.add(this.getUser(name, null, false));
        }
        return Collections.unmodifiableSet(users);
    }

    public Set<PermissionUser> getActiveUsers() {
        return new HashSet<PermissionUser>(this.users.values());
    }

    public Collection<String> getUserIdentifiers() {
        return this.backend.getUserIdentifiers();
    }

    public Collection<String> getUserNames() {
        return this.backend.getUserNames();
    }

    Set<PermissionUser> getActiveUsers(String groupName, boolean inheritance) {
        HashSet<PermissionUser> users = new HashSet<PermissionUser>();
        for (PermissionUser user : this.getActiveUsers()) {
            if (!user.inGroup(groupName, inheritance)) continue;
            users.add(user);
        }
        return Collections.unmodifiableSet(users);
    }

    Set<PermissionUser> getActiveUsers(String groupName) {
        return this.getActiveUsers(groupName, false);
    }

    public Set<PermissionUser> getUsers(String groupName, String worldName) {
        return this.getUsers(groupName, worldName, false);
    }

    public Set<PermissionUser> getUsers(String groupName) {
        return this.getUsers(groupName, false);
    }

    public Set<PermissionUser> getUsers(String groupName, String worldName, boolean inheritance) {
        HashSet<PermissionUser> users = new HashSet<PermissionUser>();
        for (PermissionUser user : this.getUsers()) {
            if (!user.inGroup(groupName, worldName, inheritance)) continue;
            users.add(user);
        }
        return Collections.unmodifiableSet(users);
    }

    public Set<PermissionUser> getUsers(String groupName, boolean inheritance) {
        HashSet<PermissionUser> users = new HashSet<PermissionUser>();
        for (PermissionUser user : this.getUsers()) {
            if (!user.inGroup(groupName, inheritance)) continue;
            users.add(user);
        }
        return Collections.unmodifiableSet(users);
    }

    public void resetUser(String userName) {
        this.users.remove(userName.toLowerCase());
    }

    public void resetUser(Player ply) {
        this.users.remove(ply.getUniqueId().toString());
        this.resetUser(ply.getName());
    }

    public void clearUserCache(String userName) {
        PermissionUser user = this.getUser(userName);
        if (user != null) {
            user.clearCache();
        }
    }

    public void clearUserCache(UUID uid) {
        PermissionUser user = this.getUser(uid);
        if (user != null) {
            user.clearCache();
        }
    }

    public void clearUserCache(Player player) {
        this.clearUserCache(player.getUniqueId());
    }

    public PermissionGroup getGroup(String groupname) {
        if (groupname == null || groupname.isEmpty()) {
            return null;
        }
        PermissionGroup group = this.groups.get(groupname.toLowerCase());
        if (group == null) {
            PermissionsGroupData data = this.backend.getGroupData(groupname);
            if (data != null) {
                group = new PermissionGroup(groupname, data, this);
                this.groups.put(groupname.toLowerCase(), group);
                try {
                    group.initialize();
                }
                catch (Exception e) {
                    this.groups.remove(groupname.toLowerCase());
                    throw new IllegalStateException("Error initializing group " + groupname, e);
                }
            } else {
                throw new IllegalStateException("Group " + groupname + " is null");
            }
        }
        return group;
    }

    public List<PermissionGroup> getGroupList() {
        LinkedList<PermissionGroup> ret = new LinkedList<PermissionGroup>();
        for (String name : this.backend.getGroupNames()) {
            ret.add(this.getGroup(name));
        }
        return Collections.unmodifiableList(ret);
    }

    @Deprecated
    public PermissionGroup[] getGroups() {
        return this.getGroupList().toArray(new PermissionGroup[0]);
    }

    public List<PermissionGroup> getGroups(String groupName, String worldName) {
        return this.getGroups(groupName, worldName, false);
    }

    public List<PermissionGroup> getGroups(String groupName) {
        return this.getGroups(groupName, null);
    }

    public List<PermissionGroup> getGroups(String groupName, String worldName, boolean inheritance) {
        LinkedList<PermissionGroup> groups = new LinkedList<PermissionGroup>();
        for (PermissionGroup group : this.getGroupList()) {
            if (groups.contains(group) || !group.isChildOf(groupName, worldName, inheritance)) continue;
            groups.add(group);
        }
        return Collections.unmodifiableList(groups);
    }

    public List<PermissionGroup> getGroups(String groupName, boolean inheritance) {
        ArrayList<PermissionGroup> groups = new ArrayList<PermissionGroup>();
        for (World world : Bukkit.getServer().getWorlds()) {
            groups.addAll(this.getGroups(groupName, world.getName(), inheritance));
        }
        groups.addAll(this.getGroups(groupName, null, inheritance));
        Collections.sort(groups);
        return Collections.unmodifiableList(groups);
    }

    public List<PermissionGroup> getDefaultGroups(String worldName) {
        LinkedList<PermissionGroup> defaults = new LinkedList<PermissionGroup>();
        for (String name : this.getBackend().getDefaultGroupNames(worldName)) {
            defaults.add(this.getGroup(name));
        }
        if (worldName != null) {
            for (String name : this.getBackend().getDefaultGroupNames(null)) {
                defaults.add(this.getGroup(name));
            }
        }
        return Collections.unmodifiableList(defaults);
    }

    public void resetGroup(String groupName) {
        this.groups.remove(groupName);
    }

    void preloadGroups() {
        for (PermissionGroup group : this.getGroupList()) {
            group.getData().load();
        }
    }

    public void setDebug(boolean debug) {
        this.debugMode = debug;
        this.callEvent(PermissionSystemEvent.Action.DEBUGMODE_TOGGLE);
    }

    public boolean isDebug() {
        return this.debugMode;
    }

    public Map<Integer, PermissionGroup> getRankLadder(String ladderName) {
        HashMap<Integer, PermissionGroup> ladder = new HashMap<Integer, PermissionGroup>();
        for (PermissionGroup group : this.getGroupList()) {
            if (!group.isRanked() || !group.getRankLadder().equalsIgnoreCase(ladderName)) continue;
            ladder.put(group.getRank(), group);
        }
        return ladder;
    }

    public List<String> getWorldInheritance(String worldName) {
        return this.backend.getWorldInheritance(worldName);
    }

    public void setWorldInheritance(String world, List<String> parentWorlds) {
        this.backend.setWorldInheritance(world, parentWorlds);
        this.callEvent(PermissionSystemEvent.Action.WORLDINHERITANCE_CHANGED);
    }

    public PermissionBackend getBackend() {
        return this.backend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackend(String backendName) throws PermissionBackendException {
        PermissionManager permissionManager = this;
        synchronized (permissionManager) {
            this.clearCache();
            this.backend = this.createBackend(backendName);
            this.preloadGroups();
        }
        this.callEvent(PermissionSystemEvent.Action.BACKEND_CHANGED);
    }

    public PermissionBackend createBackend(String backendName) throws PermissionBackendException {
        ConfigurationSection config = this.plugin.getConfiguration().getBackendConfig(backendName);
        String backendType = config.getString("type");
        if (backendType == null) {
            backendType = backendName;
            config.set("type", (Object)backendType);
        }
        return PermissionBackend.getBackend(backendType, this, config);
    }

    protected void registerTask(TimerTask task, int delay) {
        if (this.timer == null || delay == 0) {
            return;
        }
        this.timer.schedule(task, delay * 1000);
    }

    public void reset() throws PermissionBackendException {
        this.clearCache();
        if (this.backend != null) {
            this.backend.reload();
        }
        this.callEvent(PermissionSystemEvent.Action.RELOADED);
    }

    public void end() {
        try {
            this.backend.close();
            this.backend = null;
            this.reset();
        }
        catch (PermissionBackendException permissionBackendException) {
            // empty catch block
        }
        this.timer.cancel();
    }

    public void initTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer("PermissionsEx-Cleaner");
    }

    protected void clearCache() {
        this.users.clear();
        this.groups.clear();
        this.defaultGroups.clear();
        this.initTimer();
    }

    private void initBackend() throws PermissionBackendException {
        this.setBackend(this.plugin.getConfiguration().getDefaultBackend());
    }

    protected void callEvent(PermissionEvent event) {
        if (this.netEvents != null) {
            this.netEvents.callEvent((Event)event);
        } else {
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
        }
    }

    protected void callEvent(PermissionSystemEvent.Action action) {
        this.callEvent(new PermissionSystemEvent(this.getServerUUID(), action));
    }

    public PermissionMatcher getPermissionMatcher() {
        return this.matcher;
    }

    public void setPermissionMatcher(PermissionMatcher matcher) {
        this.matcher = matcher;
    }

    public Collection<String> getGroupNames() {
        return this.backend.getGroupNames();
    }

    public Logger getLogger() {
        return this.plugin.getLogger();
    }

    private class RemoteEventListener
    implements Listener {
        private RemoteEventListener() {
        }

        @EventHandler(priority=EventPriority.LOWEST)
        public void onEntityEvent(PermissionEntityEvent event) {
            boolean reloadEntity;
            boolean reloadAll;
            if (PermissionManager.this.isLocal(event)) {
                return;
            }
            switch (event.getAction()) {
                case DEFAULTGROUP_CHANGED: 
                case RANK_CHANGED: 
                case INHERITANCE_CHANGED: {
                    reloadAll = true;
                    reloadEntity = false;
                    break;
                }
                case SAVED: 
                case TIMEDPERMISSION_EXPIRED: {
                    return;
                }
                default: {
                    reloadEntity = true;
                    reloadAll = false;
                }
            }
            try {
                if (PermissionManager.this.backend != null) {
                    PermissionManager.this.backend.reload();
                }
            }
            catch (PermissionBackendException e) {
                e.printStackTrace();
            }
            if (reloadEntity) {
                switch (event.getType()) {
                    case USER: {
                        PermissionManager.this.users.remove(event.getEntityIdentifier());
                        break;
                    }
                    case GROUP: {
                        PermissionGroup group = PermissionManager.this.groups.remove(event.getEntityIdentifier());
                        if (group == null) break;
                        Iterator<PermissionUser> it = PermissionManager.this.users.values().iterator();
                        while (it.hasNext()) {
                            if (!it.next().inGroup(group, true)) continue;
                            it.remove();
                        }
                        break;
                    }
                }
            } else if (reloadAll) {
                PermissionManager.this.clearCache();
            }
        }

        @EventHandler(priority=EventPriority.LOWEST)
        public void onSystemEvent(PermissionSystemEvent event) {
            if (PermissionManager.this.isLocal(event)) {
                return;
            }
            switch (event.getAction()) {
                case BACKEND_CHANGED: 
                case DEBUGMODE_TOGGLE: 
                case REINJECT_PERMISSIBLES: {
                    return;
                }
            }
            try {
                if (PermissionManager.this.backend != null) {
                    PermissionManager.this.backend.reload();
                }
                PermissionManager.this.clearCache();
            }
            catch (PermissionBackendException e) {
                e.printStackTrace();
            }
        }
    }
}

