/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.permissions.Permission;
import ru.tehkode.permissions.HierarchyTraverser;
import ru.tehkode.permissions.PermissionGroup;
import ru.tehkode.permissions.PermissionManager;
import ru.tehkode.permissions.PermissionsData;
import ru.tehkode.permissions.events.PermissionEntityEvent;

public abstract class PermissionEntity {
    protected static final String NON_INHERITABLE_PREFIX = "#";
    protected PermissionManager manager;
    private String name;
    protected Map<String, List<String>> timedPermissions = new ConcurrentHashMap<String, List<String>>();
    protected Map<String, Long> timedPermissionsTime = new ConcurrentHashMap<String, Long>();
    protected boolean debugMode = false;

    public PermissionEntity(String name, PermissionManager manager) {
        this.manager = manager;
        this.name = name;
    }

    protected abstract PermissionsData getData();

    protected abstract void clearCache();

    public void initialize() {
        this.debugMode = this.getOptionBoolean("debug", null, this.debugMode);
    }

    public String getIdentifier() {
        return this.name;
    }

    public String getName() {
        return this.getOwnOption("name", null, this.getIdentifier());
    }

    public abstract Type getType();

    public String getOwnPrefix() {
        return this.getOwnPrefix(null);
    }

    public String getOwnPrefix(String worldName) {
        return this.getOwnOption("prefix", worldName);
    }

    public final String getOwnSuffix() {
        return this.getOwnSuffix(null);
    }

    public String getOwnSuffix(String worldName) {
        return this.getOwnOption("suffix", worldName);
    }

    public String getPrefix(String worldName) {
        String ret = (String)new HierarchyTraverser<String>(this, worldName){

            @Override
            protected String fetchLocal(PermissionEntity entity, String world) {
                String ret = entity.getOwnPrefix(world);
                return ret == null || ret.isEmpty() ? null : ret;
            }
        }.traverse();
        return ret == null ? "" : ret;
    }

    public String getPrefix() {
        return this.getPrefix(null);
    }

    public void setPrefix(String prefix, String worldName) {
        this.getData().setOption("prefix", prefix, worldName);
        this.clearCache();
        this.callEvent(PermissionEntityEvent.Action.INFO_CHANGED);
    }

    public String getSuffix(String worldName) {
        String ret = (String)new HierarchyTraverser<String>(this, worldName){

            @Override
            protected String fetchLocal(PermissionEntity entity, String world) {
                String ret = entity.getOwnSuffix(world);
                return ret == null || ret.isEmpty() ? null : ret;
            }
        }.traverse();
        return ret == null ? "" : ret;
    }

    public String getSuffix() {
        return this.getSuffix(null);
    }

    public void setSuffix(String suffix, String worldName) {
        this.getData().setOption("suffix", suffix, worldName);
        this.clearCache();
        this.callEvent(PermissionEntityEvent.Action.INFO_CHANGED);
    }

    public boolean has(String permission) {
        return this.has(permission, ((World)Bukkit.getServer().getWorlds().get(0)).getName());
    }

    public boolean has(String permission, String world) {
        if (permission != null && permission.isEmpty()) {
            return true;
        }
        String expression = this.getMatchingExpression(permission, world);
        if (this.isDebug()) {
            Logger.getLogger("Minecraft").info("User " + this.getIdentifier() + " checked for \"" + permission + "\", " + (expression == null ? "no permission found" : "\"" + expression + "\" found"));
        }
        return this.explainExpression(expression);
    }

    public List<String> getPermissions(String world) {
        return Collections.unmodifiableList(this.getPermissionsInternal(world, false));
    }

    public List<String> getOwnPermissions(String world) {
        return Collections.unmodifiableList(this.getData().getPermissions(world));
    }

    public Map<String, List<String>> getAllPermissions() {
        return this.getData().getPermissionsMap();
    }

    protected List<String> getPermissionsInternal(String worldName, final boolean filterNonInheritable) {
        final ArrayList<String> ret = new ArrayList<String>();
        new HierarchyTraverser<Void>(this, worldName){

            @Override
            protected Void fetchLocal(PermissionEntity entity, String world) {
                for (String perm : entity.getOwnPermissions(world)) {
                    if (filterNonInheritable && entity != PermissionEntity.this && perm.startsWith(PermissionEntity.NON_INHERITABLE_PREFIX)) continue;
                    ret.add(perm);
                    entity.getInheritedChildPermissions(perm, ret);
                }
                for (String perm : entity.getTimedPermissions(world)) {
                    if (filterNonInheritable && entity != PermissionEntity.this && perm.startsWith(PermissionEntity.NON_INHERITABLE_PREFIX)) continue;
                    ret.add(perm);
                    entity.getInheritedChildPermissions(perm, ret);
                }
                return null;
            }
        }.traverse();
        return ret;
    }

    protected void getInheritedChildPermissions(String perm, List<String> list) {
        this.getInheritedChildPermissions(perm, list, false);
    }

    protected void getInheritedChildPermissions(String perm, List<String> list, boolean invert) {
        if (perm.startsWith("-")) {
            invert = !invert;
            perm = perm.substring(1);
        }
        this.getInheritedChildPermissions(Bukkit.getPluginManager().getPermission(perm), list, invert);
    }

    protected void getInheritedChildPermissions(Permission perm, List<String> list, boolean invert) {
        if (perm == null) {
            return;
        }
        for (Map.Entry entry : perm.getChildren().entrySet()) {
            boolean has = (Boolean)entry.getValue() ^ invert;
            String node = (has ? "" : "-") + (String)entry.getKey();
            if (list.contains(node)) continue;
            list.add(node);
            this.getInheritedChildPermissions(node, list, !has);
        }
    }

    public void addPermission(String permission, String worldName) {
        LinkedList<String> permissions = new LinkedList<String>(this.getOwnPermissions(worldName));
        if (permissions.contains(permission)) {
            permissions.remove(permission);
        }
        permissions.addFirst(permission);
        this.setPermissions(permissions, worldName);
    }

    public void addPermission(String permission) {
        this.addPermission(permission, null);
    }

    public void removePermission(String permission, String worldName) {
        LinkedList<String> permissions = new LinkedList<String>(this.getOwnPermissions(worldName));
        permissions.remove(permission);
        this.setPermissions(permissions, worldName);
    }

    public void removePermission(String permission) {
        for (String world : this.getAllPermissions().keySet()) {
            this.removePermission(permission, world);
        }
    }

    public void setPermissions(List<String> permissions, String world) {
        this.getData().setPermissions(permissions, world);
        this.clearCache();
        this.callEvent(PermissionEntityEvent.Action.PERMISSIONS_CHANGED);
    }

    public void setPermissions(List<String> permission) {
        this.setPermissions(permission, null);
    }

    public String getOption(final String option, String world, String defaultValue) {
        String ret = (String)new HierarchyTraverser<String>(this, world){

            @Override
            protected String fetchLocal(PermissionEntity entity, String world) {
                return entity.getOwnOption(option, world, null);
            }
        }.traverse();
        if (ret == null) {
            ret = defaultValue;
        }
        return ret;
    }

    public String getOption(String option) {
        return this.getOption(option, null, null);
    }

    public String getOption(String option, String world) {
        return this.getOption(option, world, null);
    }

    public int getOptionInteger(String optionName, String world, int defaultValue) {
        try {
            return Integer.parseInt(this.getOption(optionName, world, Integer.toString(defaultValue)));
        }
        catch (NumberFormatException ignore) {
            return defaultValue;
        }
    }

    public double getOptionDouble(String optionName, String world, double defaultValue) {
        String option = this.getOption(optionName, world, Double.toString(defaultValue));
        try {
            return Double.parseDouble(option);
        }
        catch (NumberFormatException ignore) {
            return defaultValue;
        }
    }

    public boolean getOptionBoolean(String optionName, String world, boolean defaultValue) {
        String option = this.getOption(optionName, world, Boolean.toString(defaultValue));
        if ("false".equalsIgnoreCase(option)) {
            return false;
        }
        if ("true".equalsIgnoreCase(option)) {
            return true;
        }
        return defaultValue;
    }

    public void setOption(String option, String value, String world) {
        this.getData().setOption(option, value, world);
        this.clearCache();
        this.callEvent(PermissionEntityEvent.Action.OPTIONS_CHANGED);
    }

    public void setOption(String option, String value) {
        this.setOption(option, value, null);
    }

    public Map<String, String> getOptions(String world) {
        return this.getData().getOptions(world);
    }

    public Map<String, Map<String, String>> getAllOptions() {
        return this.getData().getOptionsMap();
    }

    public String getOwnOption(String option, String world, String defaultValue) {
        String ret = this.getData().getOption(option, world);
        if (ret == null) {
            return defaultValue;
        }
        return ret;
    }

    public String getOwnOption(String option) {
        return this.getOwnOption(option, null, null);
    }

    public String getOwnOption(String option, String world) {
        return this.getOwnOption(option, world, null);
    }

    public int getOwnOptionInteger(String optionName, String world, int defaultValue) {
        String option = this.getOwnOption(optionName, world, Integer.toString(defaultValue));
        try {
            return Integer.parseInt(option);
        }
        catch (NumberFormatException ignore) {
            return defaultValue;
        }
    }

    public boolean getOwnOptionBoolean(String optionName, String world, boolean defaultValue) {
        String option = this.getOwnOption(optionName, world, Boolean.toString(defaultValue));
        if ("false".equalsIgnoreCase(option)) {
            return false;
        }
        if ("true".equalsIgnoreCase(option)) {
            return true;
        }
        return defaultValue;
    }

    public double getOwnOptionDouble(String optionName, String world, double defaultValue) {
        String option = this.getOwnOption(optionName, world, Double.toString(defaultValue));
        try {
            return Double.parseDouble(option);
        }
        catch (NumberFormatException ignore) {
            return defaultValue;
        }
    }

    public void save() {
        this.getData().save();
        this.clearCache();
        this.callEvent(PermissionEntityEvent.Action.SAVED);
    }

    public void remove() {
        this.getData().remove();
        this.clearCache();
        this.callEvent(PermissionEntityEvent.Action.REMOVED);
    }

    public boolean isVirtual() {
        return this.getData().isVirtual();
    }

    public Set<String> getWorlds() {
        return this.getData().getWorlds();
    }

    public List<String> getTimedPermissions(String world) {
        if (world == null) {
            world = "";
        }
        if (!this.timedPermissions.containsKey(world)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.timedPermissions.get(world));
    }

    public int getTimedPermissionLifetime(String permission, String world) {
        if (world == null) {
            world = "";
        }
        if (!this.timedPermissionsTime.containsKey(world + ":" + permission)) {
            return 0;
        }
        return (int)(this.timedPermissionsTime.get(world + ":" + permission) - System.currentTimeMillis() / 1000L);
    }

    public void addTimedPermission(final String permission, String world, int lifeTime) {
        if (world == null) {
            world = "";
        }
        if (!this.timedPermissions.containsKey(world)) {
            this.timedPermissions.put(world, new LinkedList());
        }
        this.timedPermissions.get(world).add(permission);
        final String finalWorld = world;
        if (lifeTime > 0) {
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    PermissionEntity.this.removeTimedPermission(permission, finalWorld);
                }
            };
            this.manager.registerTask(task, lifeTime);
            this.timedPermissionsTime.put(world + ":" + permission, System.currentTimeMillis() / 1000L + (long)lifeTime);
        }
        this.clearCache();
        this.callEvent(PermissionEntityEvent.Action.PERMISSIONS_CHANGED);
    }

    public void removeTimedPermission(String permission, String world) {
        if (world == null) {
            world = "";
        }
        if (!this.timedPermissions.containsKey(world)) {
            return;
        }
        this.timedPermissions.get(world).remove(permission);
        this.timedPermissions.remove(world + ":" + permission);
        this.clearCache();
        this.callEvent(PermissionEntityEvent.Action.PERMISSIONS_CHANGED);
    }

    protected void callEvent(PermissionEntityEvent event) {
        this.manager.callEvent(event);
    }

    protected void callEvent(PermissionEntityEvent.Action action) {
        this.callEvent(new PermissionEntityEvent(this.manager.getServerUUID(), this, action));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        PermissionEntity other = (PermissionEntity)obj;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(ident=" + this.getIdentifier() + ",name=" + this.getName() + ")";
    }

    public String getMatchingExpression(String permission, String world) {
        return this.getMatchingExpression(this.getPermissions(world), permission);
    }

    public String getMatchingExpression(List<String> permissions, String permission) {
        for (String expression : permissions) {
            if (!this.isMatches(expression, permission, true)) continue;
            return expression;
        }
        return null;
    }

    public boolean isMatches(String expression, String permission, boolean additionalChecks) {
        return this.manager.getPermissionMatcher().isMatches(expression, permission);
    }

    public boolean explainExpression(String expression) {
        if (expression == null || expression.isEmpty()) {
            return false;
        }
        return !expression.startsWith("-");
    }

    public boolean isDebug() {
        return this.debugMode || this.manager.isDebug();
    }

    public void setDebug(boolean debug) {
        this.debugMode = debug;
    }

    public List<PermissionGroup> getOwnParents(String world) {
        ArrayList<PermissionGroup> ret = new ArrayList<PermissionGroup>();
        for (String group : this.getOwnParentIdentifiers(world)) {
            ret.add(this.manager.getGroup(group));
        }
        Collections.sort(ret);
        return Collections.unmodifiableList(ret);
    }

    public List<PermissionGroup> getOwnParents() {
        return this.getOwnParents(null);
    }

    public List<String> getOwnParentIdentifiers(String world) {
        return Collections.unmodifiableList(this.getData().getParents(world));
    }

    public List<String> getOwnParentIdentifiers() {
        return this.getOwnParentIdentifiers(null);
    }

    public final List<PermissionGroup> getParents(String world) {
        return Collections.unmodifiableList(this.getParentsInternal(world));
    }

    public final List<PermissionGroup> getParents() {
        return this.getParents(null);
    }

    protected List<PermissionGroup> getParentsInternal(String world) {
        final ArrayList<PermissionGroup> ret = new ArrayList<PermissionGroup>();
        new HierarchyTraverser<Void>(this, world, false){

            @Override
            protected Void fetchLocal(PermissionEntity entity, String world) {
                for (String groupName : entity.getOwnParentIdentifiers(world)) {
                    PermissionGroup group;
                    if (groupName == null || groupName.trim().isEmpty() || PermissionEntity.this instanceof PermissionGroup && groupName.equalsIgnoreCase(PermissionEntity.this.getIdentifier()) || ret.contains(group = PermissionEntity.this.manager.getGroup(groupName))) continue;
                    ret.add(group);
                }
                return null;
            }
        }.traverse();
        Collections.sort(ret);
        return ret;
    }

    public List<String> getParentIdentifiers(String world) {
        LinkedList<String> ret = new LinkedList<String>();
        for (PermissionGroup group : this.getParentsInternal(world)) {
            ret.add(group.getIdentifier());
        }
        return Collections.unmodifiableList(ret);
    }

    public List<String> getParentIdentifiers() {
        return this.getParentIdentifiers(null);
    }

    public Map<String, List<PermissionGroup>> getAllParents() {
        HashMap<String, List<PermissionGroup>> allGroups = new HashMap<String, List<PermissionGroup>>();
        for (String worldName : this.getWorlds()) {
            allGroups.put(worldName, this.getWorldParents(worldName));
        }
        allGroups.put(null, this.getWorldParents(null));
        return Collections.unmodifiableMap(allGroups);
    }

    protected List<PermissionGroup> getWorldParents(String worldName) {
        LinkedList<PermissionGroup> groups = new LinkedList<PermissionGroup>();
        for (String groupName : this.getData().getParents(worldName)) {
            PermissionGroup group;
            if (groupName == null || groupName.trim().isEmpty() || this instanceof PermissionGroup && groupName.equalsIgnoreCase(this.getIdentifier()) || groups.contains(group = this.manager.getGroup(groupName))) continue;
            groups.add(group);
        }
        Collections.sort(groups);
        return Collections.unmodifiableList(groups);
    }

    public void setParents(List<PermissionGroup> parents, String world) {
        LinkedList<String> parentNames = new LinkedList<String>();
        for (PermissionGroup group : parents) {
            parentNames.add(group.getIdentifier());
        }
        this.setParentsIdentifier(parentNames, world);
    }

    public void setParents(List<PermissionGroup> parents) {
        this.setParents(parents, null);
    }

    public void setParentsIdentifier(List<String> parentNames, String world) {
        this.getData().setParents(parentNames, world);
        this.clearCache();
        this.callEvent(PermissionEntityEvent.Action.INHERITANCE_CHANGED);
    }

    public void setParentsIdentifier(List<String> parentNames) {
        this.setParentsIdentifier(parentNames, null);
    }

    public static enum Type {
        USER,
        GROUP;

    }
}

