/*
 * Decompiled with CFR 0.152.
 */
package com.benzoft.pextabcompleter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.stream.IntStream;
import javax.net.ssl.HttpsURLConnection;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class UpdateChecker
implements Listener {
    private final int ID = 69539;
    private final Plugin plugin;
    private final String localPluginVersion;
    private String spigotPluginVersion;

    UpdateChecker(Plugin plugin) {
        this.plugin = plugin;
        this.localPluginVersion = plugin.getDescription().getVersion();
    }

    void checkForUpdate() {
        new BukkitRunnable(){

            public void run() {
                Bukkit.getScheduler().runTaskAsynchronously(UpdateChecker.this.plugin, () -> {
                    try {
                        HttpsURLConnection connection = (HttpsURLConnection)new URL("https://api.spigotmc.org/legacy/update.php?resource=69539").openConnection();
                        connection.setRequestMethod("GET");
                        UpdateChecker.this.spigotPluginVersion = new BufferedReader(new InputStreamReader(connection.getInputStream())).readLine();
                    }
                    catch (IOException e) {
                        Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&cUpdate checker failed!"));
                        e.printStackTrace();
                        this.cancel();
                        return;
                    }
                    if (!UpdateChecker.this.isLatestVersion()) {
                        Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7[&aPermissionsEx Tab Completer&7] &fA new update is available at:"));
                        Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&bhttps://www.spigotmc.org/resources/69539/updates"));
                        this.cancel();
                    }
                });
            }
        }.runTaskTimer(this.plugin, 0L, 12000L);
    }

    private boolean isLatestVersion() {
        try {
            int[] local = Arrays.stream(this.localPluginVersion.split("\\.")).mapToInt(Integer::parseInt).toArray();
            int[] spigot = Arrays.stream(this.spigotPluginVersion.split("\\.")).mapToInt(Integer::parseInt).toArray();
            return IntStream.range(0, local.length).noneMatch(i -> spigot[i] > local[i]);
        }
        catch (NumberFormatException ignored) {
            return this.localPluginVersion.equals(this.spigotPluginVersion);
        }
    }
}

