/*
 * Decompiled with CFR 0.152.
 */
package com.benzoft.pextabcompleter;

import com.benzoft.pextabcompleter.PexTabCompleter;
import com.benzoft.pextabcompleter.permissiontree.PermissionNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import ru.tehkode.permissions.bukkit.PermissionsEx;

class PexCommand {
    private final PexTabCompleter pexTabCompleter;
    private final String[] command;
    private final Map<Integer, Supplier<List<String>>> indexSuggestions;

    PexCommand(PexTabCompleter pexTabCompleter, String command) {
        this(pexTabCompleter, command, new HashMap<Integer, Supplier<List<String>>>());
    }

    PexCommand(PexTabCompleter pexTabCompleter, String command, Map<Integer, Supplier<List<String>>> indexSuggestions) {
        this.pexTabCompleter = pexTabCompleter;
        this.command = command.split(" ");
        this.indexSuggestions = indexSuggestions;
    }

    boolean isCommand(String[] input) {
        try {
            for (int i = 0; i < input.length; ++i) {
                boolean placeholder;
                String fullWord = this.command[i];
                String inputWord = input[i];
                if (i == input.length - 1 && fullWord.toLowerCase().startsWith(inputWord.toLowerCase())) {
                    return true;
                }
                boolean bl = placeholder = fullWord.equalsIgnoreCase("*") || fullWord.startsWith("<") && fullWord.endsWith(">") || fullWord.startsWith("[") && fullWord.endsWith("]");
                if (placeholder || fullWord.equalsIgnoreCase(inputWord)) continue;
                return false;
            }
            return true;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    List<String> getArgSuggestion(String[] input) {
        try {
            int lastWordIndex = input.length - 1;
            String currentWord = input[lastWordIndex];
            String nextWord = this.command[lastWordIndex];
            if (nextWord.equalsIgnoreCase("<permission>")) {
                String prevWord = input[lastWordIndex - 1];
                if (prevWord.equalsIgnoreCase("remove")) {
                    return (this.command[0].equalsIgnoreCase("user") ? PermissionsEx.getUser((String)input[1]) : PermissionsEx.getPermissionManager().getGroup(input[1])).getAllPermissions().values().stream().flatMap(Collection::stream).distinct().collect(Collectors.toList());
                }
                return this.getPermissionSuggestions(currentWord);
            }
            if (!currentWord.isEmpty() && nextWord.startsWith(currentWord)) {
                return Collections.singletonList(nextWord);
            }
            return nextWord.equalsIgnoreCase("*") ? this.indexSuggestions.getOrDefault(lastWordIndex, Collections::emptyList).get() : Collections.singletonList(nextWord);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return Collections.emptyList();
        }
    }

    private List<String> getPermissionSuggestions(String current) {
        PermissionNode end = this.pexTabCompleter.getPermissionTree().getRootNode();
        for (String node : Arrays.copyOfRange(current.substring(current.startsWith("-") ? 1 : 0).split("\\.", -1), 0, current.split("\\.", -1).length - 1)) {
            if ((end = end.getChildren().get(node)) == null) break;
        }
        return end != null ? end.getChildren().keySet().stream().map(s -> (current.startsWith("-") && !current.contains(".") ? "-" : "") + current.substring(0, current.lastIndexOf(".") + 1) + s).collect(Collectors.toList()) : Collections.emptyList();
    }
}

