/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.bukkit;

import com.google.common.cache.CacheBuilder;
import com.zachsthings.netevents.NetEventsPlugin;
import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginLogger;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import ru.tehkode.libs.net.gravitydevelopment.updater.Updater;
import ru.tehkode.permissions.NativeInterface;
import ru.tehkode.permissions.PermissionManager;
import ru.tehkode.permissions.PermissionUser;
import ru.tehkode.permissions.backends.MultiBackend;
import ru.tehkode.permissions.backends.PermissionBackend;
import ru.tehkode.permissions.backends.file.FileBackend;
import ru.tehkode.permissions.backends.memory.MemoryBackend;
import ru.tehkode.permissions.backends.sql.SQLBackend;
import ru.tehkode.permissions.bukkit.ErrorReport;
import ru.tehkode.permissions.bukkit.PermissionsExConfig;
import ru.tehkode.permissions.bukkit.RemoteEventListener;
import ru.tehkode.permissions.bukkit.SuperpermsListener;
import ru.tehkode.permissions.bukkit.commands.GroupCommands;
import ru.tehkode.permissions.bukkit.commands.PromotionCommands;
import ru.tehkode.permissions.bukkit.commands.UserCommands;
import ru.tehkode.permissions.bukkit.commands.UtilityCommands;
import ru.tehkode.permissions.bukkit.commands.WorldCommands;
import ru.tehkode.permissions.bukkit.regexperms.RegexPermissions;
import ru.tehkode.permissions.commands.CommandsManager;
import ru.tehkode.permissions.events.PermissionEvent;
import ru.tehkode.permissions.exceptions.PermissionBackendException;
import ru.tehkode.permissions.exceptions.PermissionsNotAvailable;
import ru.tehkode.utils.StringUtils;

public class PermissionsEx
extends JavaPlugin
implements NativeInterface {
    private static final int BUKKITDEV_ID = 31279;
    protected PermissionManager permissionsManager;
    protected CommandsManager commandsManager;
    private PermissionsExConfig config;
    protected SuperpermsListener superms;
    private RegexPermissions regexPerms;
    private NetEventsPlugin netEvents;
    private boolean errored = false;
    private static PermissionsEx instance;

    public PermissionsEx() {
        instance = this;
        try {
            Field field = JavaPlugin.class.getDeclaredField("logger");
            field.setAccessible(true);
            field.set(this, (Object)new PermissionsExLogger((Plugin)this));
        }
        catch (Exception exception) {
            // empty catch block
        }
        PermissionBackend.registerBackendAlias("sql", SQLBackend.class);
        PermissionBackend.registerBackendAlias("file", FileBackend.class);
        PermissionBackend.registerBackendAlias("memory", MemoryBackend.class);
        PermissionBackend.registerBackendAlias("multi", MultiBackend.class);
    }

    private void logBackendExc(PermissionBackendException e) {
        this.getLogger().log(Level.SEVERE, "\n========== UNABLE TO LOAD PERMISSIONS BACKEND =========\nYour configuration must be fixed before PEX will enable\nDetails: " + e.getMessage() + "\n=======================================================", e);
    }

    public void onLoad() {
        try {
            this.config = new PermissionsExConfig((Configuration)this.getConfig(), this);
            this.commandsManager = new CommandsManager(this);
            if (!this.getServer().getOnlineMode()) {
                this.getLogger().log(Level.WARNING, "This server is in offline mode. Unless this server is configured to integrate with a supported proxy (see http://dft.ba/-8ous), UUIDs *may not be stable*!");
            }
        }
        catch (Throwable t) {
            ErrorReport.handleError("In onLoad", t);
            this.errored = true;
        }
    }

    public void onEnable() {
        if (this.errored) {
            this.getLogger().severe("==== PermissionsEx could not be enabled due to an earlier error. Look at the previous server log for more info ====");
            this.getPluginLoader().disablePlugin((Plugin)this);
            return;
        }
        try {
            Plugin netEventsPlugin;
            try {
                CacheBuilder.class.getMethod("maximumSize", Long.TYPE);
            }
            catch (NoSuchMethodException e) {
                this.getLogger().severe("=================================================================================");
                this.getLogger().severe("As of version 1.23, PEX is only compatible with versions of Minecraft 1.8 or greater. Please downgrade to the most recent 1.22.x series version of PEX to continue.");
                this.getLogger().severe("=================================================================================");
                this.getPluginLoader().disablePlugin((Plugin)this);
                return;
            }
            if (this.permissionsManager == null) {
                this.permissionsManager = new PermissionManager(this.config, this.getLogger(), this);
            }
            try {
                OfflinePlayer.class.getMethod("getUniqueId", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                this.getLogger().severe("=================================================================================");
                this.getLogger().severe("As of version 1.21, PEX requires a version of Bukkit with UUID support to function (>1.7.5). Please download a non-UUID version of PermissionsEx to continue.");
                this.getLogger().severe("Beginning reversion of potential invalid UUID conversion");
                this.getPermissionsManager().getBackend().revertUUID();
                this.getLogger().severe("Reversion complete, disabling. PermissionsEx will not work until downgrade is complete");
                this.getLogger().severe("=================================================================================");
                this.getPluginLoader().disablePlugin((Plugin)this);
                return;
            }
            this.commandsManager.register(new UserCommands());
            this.commandsManager.register(new GroupCommands());
            this.commandsManager.register(new PromotionCommands());
            this.commandsManager.register(new WorldCommands());
            this.commandsManager.register(new UtilityCommands());
            PlayerEventsListener cleaner = new PlayerEventsListener();
            this.getServer().getPluginManager().registerEvents((Listener)cleaner, (Plugin)this);
            this.getServer().getServicesManager().register(PermissionManager.class, (Object)this.permissionsManager, (Plugin)this, ServicePriority.Normal);
            this.regexPerms = new RegexPermissions(this);
            this.superms = new SuperpermsListener(this);
            this.getServer().getPluginManager().registerEvents((Listener)this.superms, (Plugin)this);
            this.saveConfig();
            this.permissionsManager.initTimer();
            if (this.config.updaterEnabled()) {
                final Updater updater = new Updater((Plugin)this, 31279, this.getFile(), Updater.UpdateType.DEFAULT, false){

                    @Override
                    public boolean shouldUpdate(String localVerString, String remoteVerString) {
                        int remoteMinor;
                        if (localVerString.equals(remoteVerString)) {
                            return false;
                        }
                        if (PermissionsEx.this.config.alwaysUpdate()) {
                            return true;
                        }
                        if (localVerString.endsWith("-SNAPSHOT") || remoteVerString.endsWith("-SNAPSHOT")) {
                            return false;
                        }
                        String[] localVer = localVerString.split("\\.");
                        int localSuperMajor = Integer.parseInt(localVer[0]);
                        int localMajor = localVer.length > 1 ? Integer.parseInt(localVer[1]) : 0;
                        int localMinor = localVer.length > 2 ? Integer.parseInt(localVer[2]) : 0;
                        String[] remoteVer = remoteVerString.split("\\.");
                        int remoteSuperMajor = Integer.parseInt(remoteVer[0]);
                        int remoteMajor = remoteVer.length > 1 ? Integer.parseInt(remoteVer[1]) : 0;
                        int n = remoteMinor = remoteVer.length > 2 ? Integer.parseInt(remoteVer[2]) : 0;
                        if (localSuperMajor > remoteSuperMajor || localSuperMajor == remoteSuperMajor && localMajor > remoteMajor || localSuperMajor == remoteSuperMajor && localMajor == remoteMajor && localMinor >= remoteMinor) {
                            return false;
                        }
                        if (localSuperMajor == remoteSuperMajor && localMajor == remoteMajor) {
                            return true;
                        }
                        PermissionsEx.this.getLogger().warning("An update to " + PermissionsEx.this.getDescription().getName() + " version " + remoteVerString + " is available to download from http://dev.bukkit.org/bukkit-plugins/permissionsex/. Please review the changes and update as soon as possible!");
                        return false;
                    }
                };
                this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, new Runnable(){

                    @Override
                    public void run() {
                        switch (updater.getResult()) {
                            case SUCCESS: {
                                PermissionsEx.this.getLogger().info("An update to " + updater.getLatestName() + " was downloaded and will be applied on next server launch.");
                            }
                        }
                    }
                });
            }
            if (this.getConfiguration().useNetEvents() && (netEventsPlugin = this.getServer().getPluginManager().getPlugin("NetEvents")) != null && netEventsPlugin.isEnabled()) {
                NetEventsPlugin netEvents = (NetEventsPlugin)netEventsPlugin;
                this.getServer().getPluginManager().registerEvents((Listener)new RemoteEventListener(netEvents, this.permissionsManager), (Plugin)this);
                this.netEvents = netEvents;
            }
        }
        catch (PermissionBackendException e) {
            this.logBackendExc(e);
            this.getPluginLoader().disablePlugin((Plugin)this);
        }
        catch (Throwable t) {
            ErrorReport.handleError("Error while enabling: ", t);
            this.getPluginLoader().disablePlugin((Plugin)this);
        }
    }

    public void onDisable() {
        try {
            if (this.permissionsManager != null) {
                this.permissionsManager.end();
                this.getServer().getServicesManager().unregister(PermissionManager.class, (Object)this.permissionsManager);
                this.permissionsManager = null;
            }
            if (this.regexPerms != null) {
                this.regexPerms.onDisable();
                this.regexPerms = null;
            }
            if (this.superms != null) {
                this.superms.onDisable();
                this.superms = null;
            }
        }
        catch (Throwable t) {
            ErrorReport.handleError("While disabling", t);
        }
        ErrorReport.shutdown();
    }

    public boolean onCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        try {
            PluginDescriptionFile pdf = this.getDescription();
            if (args.length > 0) {
                return this.commandsManager.execute(sender, command, args);
            }
            if (sender instanceof Player) {
                sender.sendMessage("[" + ChatColor.RED + "PermissionsEx" + ChatColor.WHITE + "] version [" + ChatColor.BLUE + pdf.getVersion() + ChatColor.WHITE + "]");
                return this.permissionsManager == null || !this.permissionsManager.has((Player)sender, "permissions.manage");
            }
            sender.sendMessage("[PermissionsEx] version [" + pdf.getVersion() + "]");
            return false;
        }
        catch (Throwable t) {
            ErrorReport.handleError("While " + sender.getName() + " was executing /" + command.getName() + " " + StringUtils.implode(args, " "), t, sender);
            return true;
        }
    }

    public boolean requiresLateUserSetup() {
        return this.getServer().getPluginManager().isPluginEnabled("LilyPad-Connect");
    }

    public PermissionsExConfig getConfiguration() {
        return this.config;
    }

    public boolean isDebug() {
        return this.permissionsManager != null && this.permissionsManager.isDebug();
    }

    public static Plugin getPlugin() {
        return instance;
    }

    public RegexPermissions getRegexPerms() {
        return this.regexPerms;
    }

    @Override
    public String UUIDToName(UUID uid) {
        Player ply = null;
        try {
            ply = this.getServer().getPlayer(uid);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        return ply != null ? ply.getName() : null;
    }

    @Override
    public UUID nameToUUID(String name) {
        OfflinePlayer player = this.getServer().getOfflinePlayer(name);
        UUID userUUID = null;
        try {
            userUUID = player.getUniqueId();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return userUUID;
    }

    @Override
    public boolean isOnline(UUID uuid) {
        Player player = this.getServer().getPlayer(uuid);
        return player != null && player.isOnline();
    }

    @Override
    public UUID getServerUUID() {
        return this.netEvents == null ? null : this.netEvents.getServerUUID();
    }

    @Override
    public void callEvent(PermissionEvent event) {
        if (this.netEvents != null) {
            this.netEvents.callEvent((Event)event);
        } else {
            this.getServer().getPluginManager().callEvent((Event)event);
        }
    }

    public static boolean isAvailable() {
        Plugin plugin = PermissionsEx.getPlugin();
        return plugin.isEnabled() && ((PermissionsEx)plugin).permissionsManager != null;
    }

    public static PermissionManager getPermissionManager() {
        if (!PermissionsEx.isAvailable()) {
            throw new PermissionsNotAvailable();
        }
        return ((PermissionsEx)PermissionsEx.getPlugin()).permissionsManager;
    }

    public PermissionManager getPermissionsManager() {
        return this.permissionsManager;
    }

    public static PermissionUser getUser(Player player) {
        return PermissionsEx.getPermissionManager().getUser(player);
    }

    public static PermissionUser getUser(String name) {
        return PermissionsEx.getPermissionManager().getUser(name);
    }

    public boolean has(Player player, String permission) {
        return this.permissionsManager.has(player, permission);
    }

    public boolean has(Player player, String permission, String world) {
        return this.permissionsManager.has(player, permission, world);
    }

    public class PlayerEventsListener
    implements Listener {
        @EventHandler(priority=EventPriority.MONITOR)
        public void onAsyncPlayerPreLogin(AsyncPlayerPreLoginEvent event) {
            if (event.getLoginResult() == AsyncPlayerPreLoginEvent.Result.ALLOWED && !PermissionsEx.this.requiresLateUserSetup()) {
                PermissionsEx.this.getPermissionsManager().cacheUser(event.getUniqueId().toString(), event.getName());
            }
        }

        @EventHandler
        public void onPlayerLogin(PlayerJoinEvent event) {
            try {
                PermissionUser user = PermissionsEx.this.getPermissionsManager().getUser(event.getPlayer());
                if (!user.isVirtual()) {
                    if (!event.getPlayer().getName().equals(user.getOption("name"))) {
                        user.setOption("name", event.getPlayer().getName());
                    }
                    if (!PermissionsEx.this.config.shouldLogPlayers()) {
                        return;
                    }
                    user.setOption("last-login-time", Long.toString(System.currentTimeMillis() / 1000L));
                }
            }
            catch (Throwable t) {
                ErrorReport.handleError("While login cleanup event", t);
            }
        }

        @EventHandler
        public void onPlayerQuit(PlayerQuitEvent event) {
            try {
                PermissionUser user = PermissionsEx.this.getPermissionsManager().getUser(event.getPlayer());
                if (!user.isVirtual()) {
                    if (PermissionsEx.this.config.shouldLogPlayers()) {
                        user.setOption("last-logout-time", Long.toString(System.currentTimeMillis() / 1000L));
                    }
                    user.getName();
                }
                PermissionsEx.this.getPermissionsManager().resetUser(event.getPlayer());
            }
            catch (Throwable t) {
                ErrorReport.handleError("While logout cleanup event", t);
            }
        }
    }

    private static class PermissionsExLogger
    extends PluginLogger {
        protected PermissionsExLogger(Plugin plugin) {
            super(plugin);
            try {
                Field replace = PluginLogger.class.getDeclaredField("pluginName");
                replace.setAccessible(true);
                replace.set((Object)this, "");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public boolean isDay() {
            Calendar cal = Calendar.getInstance();
            return cal.get(2) == 3 && cal.get(5) == 1;
        }

        public void log(LogRecord record) {
            record.setMessage("[" + (this.isDay() ? "PermissionSex" : "PermissionsEx") + "] " + record.getMessage());
            super.log(record);
        }
    }
}

