/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import ru.tehkode.permissions.NativeInterface;
import ru.tehkode.permissions.PermissionGroup;
import ru.tehkode.permissions.PermissionMatcher;
import ru.tehkode.permissions.PermissionUser;
import ru.tehkode.permissions.PermissionsGroupData;
import ru.tehkode.permissions.PermissionsUserData;
import ru.tehkode.permissions.RegExpMatcher;
import ru.tehkode.permissions.backends.PermissionBackend;
import ru.tehkode.permissions.bukkit.PermissionsExConfig;
import ru.tehkode.permissions.events.PermissionEvent;
import ru.tehkode.permissions.events.PermissionSystemEvent;
import ru.tehkode.permissions.exceptions.PermissionBackendException;

public class PermissionManager {
    public static final int TRANSIENT_PERMISSION = 0;
    protected ConcurrentMap<String, PermissionUser> users = new ConcurrentHashMap<String, PermissionUser>();
    protected ConcurrentMap<String, PermissionGroup> groups = new ConcurrentHashMap<String, PermissionGroup>();
    protected PermissionBackend backend = null;
    private final PermissionsExConfig config;
    private final NativeInterface nativeI;
    private final Logger logger;
    protected ScheduledExecutorService executor;
    private final Map<String, ScheduledFuture<?>> clearTimedGroupsTasks = new HashMap();
    protected boolean debugMode = false;
    protected boolean allowOps = false;
    protected boolean userAddGroupsLast = false;
    protected PermissionMatcher matcher = new RegExpMatcher();

    public PermissionManager(PermissionsExConfig config, Logger logger, NativeInterface nativeI) throws PermissionBackendException {
        this.config = config;
        this.logger = logger;
        this.nativeI = nativeI;
        this.debugMode = config.isDebug();
        this.allowOps = config.allowOps();
        this.userAddGroupsLast = config.userAddGroupsLast();
        this.initBackend();
    }

    UUID getServerUUID() {
        return this.nativeI.getServerUUID();
    }

    public boolean shouldCreateUserRecords() {
        return this.config.createUserRecords();
    }

    public PermissionsExConfig getConfiguration() {
        return this.config;
    }

    void scheduleTimedGroupsCheck(long nextExpiration, final String identifier) {
        ScheduledFuture<?> future = this.clearTimedGroupsTasks.get(identifier);
        long newDelay = nextExpiration - System.currentTimeMillis() / 1000L;
        if (future == null || future.isDone() || future.getDelay(TimeUnit.SECONDS) > newDelay) {
            this.clearTimedGroupsTasks.put(identifier, this.executor.schedule(new Runnable(){

                @Override
                public void run() {
                    PermissionManager.this.getUser(identifier).updateTimedGroups();
                    PermissionManager.this.clearTimedGroupsTasks.remove(identifier);
                }
            }, newDelay, TimeUnit.SECONDS));
        }
    }

    public boolean has(Player player, String permission) {
        return this.has(player.getUniqueId(), permission, player.getWorld().getName());
    }

    public boolean has(Player player, String permission, String world) {
        return this.has(player.getUniqueId(), permission, world);
    }

    public boolean has(String playerName, String permission, String world) {
        PermissionUser user = this.getUser(playerName);
        if (user == null) {
            return false;
        }
        return user.has(permission, world);
    }

    public boolean has(UUID playerId, String permission, String world) {
        PermissionUser user = this.getUser(playerId);
        return user != null && user.has(permission, world);
    }

    public PermissionUser getUser(String username) {
        if (username == null || username.isEmpty()) {
            throw new IllegalArgumentException("Null or empty name passed! Name must not be empty");
        }
        try {
            if (username.length() != 36) {
                throw new IllegalArgumentException("not a uuid, try stuff");
            }
            return this.getUser(UUID.fromString(username));
        }
        catch (IllegalArgumentException ex) {
            boolean online;
            UUID userUUID = this.nativeI.nameToUUID(username);
            boolean bl = online = userUUID != null && this.nativeI.isOnline(userUUID);
            if (userUUID != null && (this.nativeI.isOnline(userUUID) || this.backend.hasUser(userUUID.toString()))) {
                return this.getUser(userUUID.toString(), username, online);
            }
            return this.getUser(username, null, false);
        }
    }

    public void cacheUser(String ident, String fallbackName) {
        this.getUser(ident, fallbackName, true);
    }

    public PermissionUser getUser(Player player) {
        return this.getUser(player.getUniqueId().toString(), player.getName(), true);
    }

    public PermissionUser getUser(UUID uid) {
        String fallbackName;
        String identifier = uid.toString();
        if (this.users.containsKey(identifier)) {
            return this.getUser(identifier, null, false);
        }
        return this.getUser(identifier, fallbackName, (fallbackName = this.nativeI.UUIDToName(uid)) != null);
    }

    private PermissionUser getUser(String identifier, String fallbackName, boolean store) {
        PermissionUser user = (PermissionUser)this.users.get(identifier);
        if (user != null) {
            return user;
        }
        PermissionsUserData data = this.backend.getUserData(identifier);
        if (data != null) {
            PermissionUser newUser;
            if (fallbackName != null && data.isVirtual() && this.backend.hasUser(fallbackName)) {
                PermissionsUserData oldData;
                if (this.isDebug()) {
                    this.getLogger().info("Converting user " + fallbackName + " (UUID " + identifier + ") to UUID-based storage");
                }
                if ((oldData = this.backend.getUserData(fallbackName)).setIdentifier(identifier)) {
                    data = oldData;
                    data.setOption("name", fallbackName, null);
                    this.resetUser(fallbackName);
                } else {
                    throw new IllegalStateException("User already exists with new id " + identifier + " (converting from " + fallbackName + ")");
                }
            }
            user = new PermissionUser(identifier, data, this);
            user.initialize();
            if (store && (newUser = this.users.put(identifier, user)) != null) {
                user = newUser;
            }
        } else {
            throw new IllegalStateException("User " + identifier + " is null");
        }
        return user;
    }

    public Set<PermissionUser> getUsers() {
        HashSet<PermissionUser> users = new HashSet<PermissionUser>();
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            users.add(this.getUser(p));
        }
        for (String name : this.backend.getUserIdentifiers()) {
            users.add(this.getUser(name, null, false));
        }
        return Collections.unmodifiableSet(users);
    }

    public Set<PermissionUser> getActiveUsers() {
        return new HashSet<PermissionUser>(this.users.values());
    }

    public Collection<String> getUserIdentifiers() {
        return this.backend.getUserIdentifiers();
    }

    public Collection<String> getUserNames() {
        return this.backend.getUserNames();
    }

    Set<PermissionUser> getActiveUsers(String groupName, boolean inheritance) {
        HashSet<PermissionUser> users = new HashSet<PermissionUser>();
        for (PermissionUser user : this.getActiveUsers()) {
            if (!user.inGroup(groupName, inheritance)) continue;
            users.add(user);
        }
        return Collections.unmodifiableSet(users);
    }

    Set<PermissionUser> getActiveUsers(String groupName) {
        return this.getActiveUsers(groupName, false);
    }

    public Set<PermissionUser> getUsers(String groupName, String worldName) {
        return this.getUsers(groupName, worldName, false);
    }

    public Set<PermissionUser> getUsers(String groupName) {
        return this.getUsers(groupName, false);
    }

    public Set<PermissionUser> getUsers(String groupName, String worldName, boolean inheritance) {
        HashSet<PermissionUser> users = new HashSet<PermissionUser>();
        for (PermissionUser user : this.getUsers()) {
            if (!user.inGroup(groupName, worldName, inheritance)) continue;
            users.add(user);
        }
        return Collections.unmodifiableSet(users);
    }

    public Set<PermissionUser> getUsers(String groupName, boolean inheritance) {
        HashSet<PermissionUser> users = new HashSet<PermissionUser>();
        for (PermissionUser user : this.getUsers()) {
            if (!user.inGroup(groupName, inheritance)) continue;
            users.add(user);
        }
        return Collections.unmodifiableSet(users);
    }

    public void resetUser(String userName) {
        this.users.remove(userName.toLowerCase());
    }

    public void resetUser(Player ply) {
        this.users.remove(ply.getUniqueId().toString());
        this.resetUser(ply.getName());
    }

    public void clearUserCache(String userName) {
        PermissionUser user = this.getUser(userName);
        if (user != null) {
            user.clearCache();
        }
    }

    public void clearUserCache(UUID uid) {
        PermissionUser user = this.getUser(uid);
        if (user != null) {
            user.clearCache();
        }
    }

    public void clearUserCache(Player player) {
        this.clearUserCache(player.getUniqueId());
    }

    public PermissionGroup getGroup(String groupname) {
        if (groupname == null || groupname.isEmpty()) {
            return null;
        }
        PermissionGroup group = (PermissionGroup)this.groups.get(groupname.toLowerCase());
        if (group == null) {
            PermissionsGroupData data = this.backend.getGroupData(groupname);
            if (data != null) {
                group = new PermissionGroup(groupname, data, this);
                PermissionGroup oldGroup = this.groups.putIfAbsent(groupname.toLowerCase(), group);
                if (oldGroup != null) {
                    return oldGroup;
                }
                try {
                    group.initialize();
                }
                catch (Exception e) {
                    this.groups.remove(groupname.toLowerCase());
                    throw new IllegalStateException("Error initializing group " + groupname, e);
                }
            } else {
                throw new IllegalStateException("Group " + groupname + " is null");
            }
        }
        return group;
    }

    public List<PermissionGroup> getGroupList() {
        LinkedList<PermissionGroup> ret = new LinkedList<PermissionGroup>();
        for (String name : this.backend.getGroupNames()) {
            ret.add(this.getGroup(name));
        }
        return Collections.unmodifiableList(ret);
    }

    @Deprecated
    public PermissionGroup[] getGroups() {
        return this.getGroupList().toArray(new PermissionGroup[0]);
    }

    public List<PermissionGroup> getGroups(String groupName, String worldName) {
        return this.getGroups(groupName, worldName, false);
    }

    public List<PermissionGroup> getGroups(String groupName) {
        return this.getGroups(groupName, null);
    }

    public List<PermissionGroup> getGroups(String groupName, String worldName, boolean inheritance) {
        LinkedList<PermissionGroup> groups = new LinkedList<PermissionGroup>();
        for (PermissionGroup group : this.getGroupList()) {
            if (groups.contains(group) || !group.isChildOf(groupName, worldName, inheritance)) continue;
            groups.add(group);
        }
        return Collections.unmodifiableList(groups);
    }

    public List<PermissionGroup> getGroups(String groupName, boolean inheritance) {
        ArrayList<PermissionGroup> groups = new ArrayList<PermissionGroup>();
        for (World world : Bukkit.getServer().getWorlds()) {
            groups.addAll(this.getGroups(groupName, world.getName(), inheritance));
        }
        groups.addAll(this.getGroups(groupName, null, inheritance));
        Collections.sort(groups);
        return Collections.unmodifiableList(groups);
    }

    public List<PermissionGroup> getDefaultGroups(String worldName) {
        LinkedList<PermissionGroup> defaults = new LinkedList<PermissionGroup>();
        for (PermissionGroup grp : this.getGroupList()) {
            if (!grp.isDefault(worldName) && (worldName == null || !grp.isDefault(null))) continue;
            defaults.add(grp);
        }
        return Collections.unmodifiableList(defaults);
    }

    public PermissionGroup resetGroup(String groupName) {
        return (PermissionGroup)this.groups.remove(groupName.toLowerCase());
    }

    void preloadGroups() {
        for (PermissionGroup group : this.getGroupList()) {
            group.getData().load();
        }
    }

    public void setDebug(boolean debug) {
        this.debugMode = debug;
        this.callEvent(PermissionSystemEvent.Action.DEBUGMODE_TOGGLE);
    }

    public boolean isDebug() {
        return this.debugMode;
    }

    public Map<Integer, PermissionGroup> getRankLadder(String ladderName) {
        HashMap<Integer, PermissionGroup> ladder = new HashMap<Integer, PermissionGroup>();
        for (PermissionGroup group : this.getGroupList()) {
            if (!group.isRanked() || !group.getRankLadder().equalsIgnoreCase(ladderName)) continue;
            ladder.put(group.getRank(), group);
        }
        return ladder;
    }

    public List<String> getWorldInheritance(String worldName) {
        return this.backend.getWorldInheritance(worldName);
    }

    public void setWorldInheritance(String world, List<String> parentWorlds) {
        this.backend.setWorldInheritance(world, parentWorlds);
        for (PermissionUser user : this.getActiveUsers()) {
            user.clearCache();
        }
        this.callEvent(PermissionSystemEvent.Action.WORLDINHERITANCE_CHANGED);
    }

    public PermissionBackend getBackend() {
        return this.backend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackend(String backendName) throws PermissionBackendException {
        PermissionManager permissionManager = this;
        synchronized (permissionManager) {
            this.clearCache();
            this.backend = this.createBackend(backendName);
            this.preloadGroups();
        }
        this.callEvent(PermissionSystemEvent.Action.BACKEND_CHANGED);
    }

    public PermissionBackend createBackend(String backendName) throws PermissionBackendException {
        ConfigurationSection config = this.config.getBackendConfig(backendName);
        String backendType = config.getString("type");
        if (backendType == null) {
            backendType = backendName;
            config.set("type", (Object)backendType);
        }
        return PermissionBackend.getBackend(backendType, this, config);
    }

    protected void registerTask(TimerTask task, int delay) {
        if (this.executor == null || delay == 0) {
            return;
        }
        this.executor.schedule(task, (long)delay, TimeUnit.SECONDS);
    }

    public void reset() throws PermissionBackendException {
        this.reset(true);
    }

    public void reset(boolean callEvent) throws PermissionBackendException {
        this.clearCache();
        if (this.backend != null) {
            this.backend.reload();
        }
        if (callEvent) {
            this.callEvent(PermissionSystemEvent.Action.RELOADED);
        }
    }

    public void end() {
        try {
            if (this.backend != null) {
                this.backend.close();
                this.backend = null;
            }
            this.reset();
        }
        catch (PermissionBackendException permissionBackendException) {
            // empty catch block
        }
        this.executor.shutdown();
        this.executor = null;
    }

    public void initTimer() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
        this.executor = Executors.newSingleThreadScheduledExecutor();
    }

    protected void clearCache() {
        this.users.clear();
        this.groups.clear();
        this.initTimer();
    }

    private void initBackend() throws PermissionBackendException {
        this.setBackend(this.config.getDefaultBackend());
    }

    protected void callEvent(PermissionEvent event) {
        this.nativeI.callEvent(event);
    }

    protected void callEvent(PermissionSystemEvent.Action action) {
        this.callEvent(new PermissionSystemEvent(this.getServerUUID(), action));
    }

    public PermissionMatcher getPermissionMatcher() {
        return this.matcher;
    }

    public void setPermissionMatcher(PermissionMatcher matcher) {
        this.matcher = matcher;
    }

    public Collection<String> getGroupNames() {
        return this.backend.getGroupNames();
    }

    public Logger getLogger() {
        return this.logger;
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    public boolean shouldSaveDefaultGroup() {
        return this.config.saveDefaultGroup();
    }
}

