/*
 * Decompiled with CFR 0.152.
 */
package net.luckperms.api.context;

import java.util.Objects;
import java.util.function.Function;
import net.luckperms.api.context.ContextConsumer;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;
import org.checkerframework.checker.nullness.qual.NonNull;

@FunctionalInterface
public interface ContextCalculator<T> {
    public static <T> @NonNull ContextCalculator<T> forSingleContext(@NonNull String key, @NonNull Function<T, String> valueFunction) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(valueFunction, "valueFunction");
        return (target, consumer) -> {
            String value = (String)valueFunction.apply(target);
            if (value != null) {
                consumer.accept(key, value);
            }
        };
    }

    public void calculate(@NonNull T var1, @NonNull ContextConsumer var2);

    default public @NonNull ContextSet estimatePotentialContexts() {
        return ImmutableContextSet.empty();
    }
}

