/*
 * Decompiled with CFR 0.152.
 */
package net.craftcitizen.imagemaps.clcore.util;

import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class ParticleUtil {
    private ParticleUtil() {
    }

    public static void spawnParticleSingleBeam(Location startingLocation) {
        ParticleUtil.spawnSingleParticleBeam(startingLocation, Color.WHITE);
    }

    public static void spawnSingleParticleBeam(Location startingLocation, Color color) {
        Location center = startingLocation.clone();
        Particle.DustOptions particle = new Particle.DustOptions(color, 1.0f);
        center.setX(center.getX() + 0.5);
        center.setZ(center.getZ() + 0.5);
        for (double i = startingLocation.getY(); i < startingLocation.getY() + 1.0; i += 0.05) {
            center.setY(i);
            center.getWorld().spawnParticle(Particle.REDSTONE, center, 1, (Object)particle);
        }
    }

    public static void spawnParticleCircle(Location startingLocation) {
        ParticleUtil.spawnParticleCircle(startingLocation, 1);
    }

    public static void spawnParticleCircle(Location startingLocation, int radius) {
        ParticleUtil.spawnParticleCircle(startingLocation, radius, Color.WHITE);
    }

    public static void spawnParticleCircle(Location startingLocation, int radius, Color color) {
        World world = startingLocation.getWorld();
        Particle.DustOptions particle = new Particle.DustOptions(color, 1.0f);
        double increment = 0.041887902047863905;
        for (int i = 0; i < 150; ++i) {
            double angle = (double)i * increment;
            double x = startingLocation.getX() + 0.5 + (double)radius * Math.cos(angle);
            double z = startingLocation.getZ() + 0.5 + (double)radius * Math.sin(angle);
            world.spawnParticle(Particle.REDSTONE, new Location(world, x, startingLocation.getY(), z), 1, (Object)particle);
        }
    }

    public static void spawnParticleRect(Location start, Location end) {
        ParticleUtil.spawnParticleRect(start, end, Color.WHITE);
    }

    public static void spawnParticleRect(Location pos1, Location pos2, Color color) {
        if (pos1.getWorld() != pos2.getWorld()) {
            return;
        }
        World w = pos1.getWorld();
        Particle.DustOptions particle = new Particle.DustOptions(color, 1.0f);
        BoundingBox bb = new BoundingBox(pos1.getX(), pos1.getY(), pos1.getZ(), pos2.getX(), pos2.getY(), pos2.getZ());
        ParticleUtil.spawnParticleLine(new Location(w, bb.getMinX(), bb.getMinY(), bb.getMinZ()), new Location(w, bb.getMaxX(), bb.getMinY(), bb.getMinZ()), particle);
        ParticleUtil.spawnParticleLine(new Location(w, bb.getMinX(), bb.getMaxY(), bb.getMinZ()), new Location(w, bb.getMaxX(), bb.getMaxY(), bb.getMinZ()), particle);
        ParticleUtil.spawnParticleLine(new Location(w, bb.getMinX(), bb.getMinY(), bb.getMaxZ()), new Location(w, bb.getMaxX(), bb.getMinY(), bb.getMaxZ()), particle);
        ParticleUtil.spawnParticleLine(new Location(w, bb.getMinX(), bb.getMaxY(), bb.getMaxZ()), new Location(w, bb.getMaxX(), bb.getMaxY(), bb.getMaxZ()), particle);
        ParticleUtil.spawnParticleLine(new Location(w, bb.getMinX(), bb.getMinY(), bb.getMinZ()), new Location(w, bb.getMinX(), bb.getMaxY(), bb.getMinZ()), particle);
        ParticleUtil.spawnParticleLine(new Location(w, bb.getMaxX(), bb.getMinY(), bb.getMinZ()), new Location(w, bb.getMaxX(), bb.getMaxY(), bb.getMinZ()), particle);
        ParticleUtil.spawnParticleLine(new Location(w, bb.getMinX(), bb.getMinY(), bb.getMaxZ()), new Location(w, bb.getMinX(), bb.getMaxY(), bb.getMaxZ()), particle);
        ParticleUtil.spawnParticleLine(new Location(w, bb.getMaxX(), bb.getMinY(), bb.getMaxZ()), new Location(w, bb.getMaxX(), bb.getMaxY(), bb.getMaxZ()), particle);
        ParticleUtil.spawnParticleLine(new Location(w, bb.getMinX(), bb.getMinY(), bb.getMinZ()), new Location(w, bb.getMinX(), bb.getMinY(), bb.getMaxZ()), particle);
        ParticleUtil.spawnParticleLine(new Location(w, bb.getMaxX(), bb.getMinY(), bb.getMinZ()), new Location(w, bb.getMaxX(), bb.getMinY(), bb.getMaxZ()), particle);
        ParticleUtil.spawnParticleLine(new Location(w, bb.getMinX(), bb.getMaxY(), bb.getMinZ()), new Location(w, bb.getMinX(), bb.getMaxY(), bb.getMaxZ()), particle);
        ParticleUtil.spawnParticleLine(new Location(w, bb.getMaxX(), bb.getMaxY(), bb.getMinZ()), new Location(w, bb.getMaxX(), bb.getMaxY(), bb.getMaxZ()), particle);
    }

    private static void spawnParticleLine(Location start, Location end, Particle.DustOptions particle) {
        double step = 0.1;
        Vector direction = end.toVector().subtract(start.toVector());
        double numParticles = direction.length() / step;
        direction.multiply(1.0 / numParticles);
        Location current = start.clone();
        int i = 0;
        while ((double)i < numParticles) {
            current.getWorld().spawnParticle(Particle.REDSTONE, current, 1, (Object)particle);
            current.add(direction);
            ++i;
        }
    }
}

