/*
 * Decompiled with CFR 0.152.
 */
package net.craftcitizen.imagemaps;

import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import net.craftcitizen.imagemaps.ImageMaps;
import net.craftcitizen.imagemaps.clcore.LambdaRunnable;
import org.bukkit.entity.Player;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapPalette;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;

public class ImageMapRenderer
extends MapRenderer {
    private ImageMaps plugin;
    private BufferedImage image = null;
    private boolean first = true;
    private final int x;
    private final int y;
    private final double scale;

    public ImageMapRenderer(ImageMaps plugin, BufferedImage image, int x, int y, double scale) {
        this.plugin = plugin;
        this.x = x;
        this.y = y;
        this.scale = scale;
        this.recalculateInput(image);
    }

    public void recalculateInput(BufferedImage input) {
        if ((long)(this.x * 128) > Math.round((double)input.getWidth() * this.scale) || (long)(this.y * 128) > Math.round((double)input.getHeight() * this.scale)) {
            return;
        }
        int x1 = (int)Math.floor((double)(this.x * 128) / this.scale);
        int y1 = (int)Math.floor((double)(this.y * 128) / this.scale);
        int x2 = (int)Math.ceil(Math.min((double)input.getWidth(), (double)((this.x + 1) * 128) / this.scale));
        int y2 = (int)Math.ceil(Math.min((double)input.getHeight(), (double)((this.y + 1) * 128) / this.scale));
        if (x2 - x1 <= 0 || y2 - y1 <= 0) {
            return;
        }
        this.image = input.getSubimage(x1, y1, x2 - x1, y2 - y1);
        if (this.scale != 1.0) {
            BufferedImage resized = new BufferedImage(128, 128, input.getType() == 0 ? this.image.getType() : input.getType());
            AffineTransform at = new AffineTransform();
            at.scale(this.scale, this.scale);
            AffineTransformOp scaleOp = new AffineTransformOp(at, 2);
            this.image = scaleOp.filter(this.image, resized);
        }
        this.first = true;
    }

    public void render(MapView view, MapCanvas canvas, Player player) {
        if (this.image != null && this.first) {
            new LambdaRunnable(() -> {
                byte[] imageData = MapPalette.imageToBytes((Image)this.image);
                new LambdaRunnable(() -> {
                    for (int x2 = 0; x2 < this.image.getWidth(null); ++x2) {
                        for (int y2 = 0; y2 < this.image.getHeight(null); ++y2) {
                            canvas.setPixel(x2, y2, imageData[y2 * this.image.getWidth(null) + x2]);
                        }
                    }
                }).runTaskLater((Plugin)this.plugin, System.nanoTime() % 20L);
            }).runTaskAsynchronously((Plugin)this.plugin);
            this.first = false;
        }
    }
}

