/*
 * Decompiled with CFR 0.152.
 */
package net.craftcitizen.imagemaps;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Collections;
import java.util.List;
import net.craftcitizen.imagemaps.ImageMapSubCommand;
import net.craftcitizen.imagemaps.ImageMaps;
import net.craftcitizen.imagemaps.clcore.Utils;
import net.craftcitizen.imagemaps.clcore.util.MessageLevel;
import net.craftcitizen.imagemaps.clcore.util.MessageUtil;
import net.craftcitizen.imagemaps.clcore.util.Tuple;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class ImageMapInfoCommand
extends ImageMapSubCommand {
    public ImageMapInfoCommand(ImageMaps plugin) {
        super("imagemaps.info", plugin, true);
    }

    @Override
    protected String execute(CommandSender sender, Command cmd, String label, String[] args) {
        if (!this.checkSender(sender)) {
            MessageUtil.sendMessage((Plugin)this.getPlugin(), sender, MessageLevel.WARNING, "You can't run this command.");
            return null;
        }
        if (args.length < 2) {
            MessageUtil.sendMessage((Plugin)this.getPlugin(), sender, MessageLevel.WARNING, "You must specify a file name.");
            return null;
        }
        String filename = args[1];
        BufferedImage image = this.getPlugin().getImage(filename);
        if (image == null) {
            MessageUtil.sendMessage((Plugin)this.getPlugin(), sender, MessageLevel.WARNING, "No image with this name exists.");
            return null;
        }
        Tuple<Integer, Integer> size = this.getPlugin().getImageSize(filename, null);
        TextComponent reloadAction = new TextComponent("[Reload]");
        reloadAction.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/imagemap reload \"%s\"", filename)));
        reloadAction.setColor(ChatColor.GOLD);
        TextComponent placeAction = new TextComponent("[Place]");
        placeAction.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/imagemap place \"%s\"", filename)));
        placeAction.setColor(ChatColor.GOLD);
        TextComponent deleteAction = new TextComponent("[Delete]");
        deleteAction.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/imagemap delete \"%s\"", filename)));
        deleteAction.setColor(ChatColor.RED);
        TextComponent actions = new TextComponent("Action: ");
        actions.addExtra((BaseComponent)reloadAction);
        actions.addExtra(" ");
        actions.addExtra((BaseComponent)placeAction);
        actions.addExtra(" ");
        actions.addExtra((BaseComponent)deleteAction);
        MessageUtil.sendMessage((Plugin)this.getPlugin(), sender, MessageLevel.INFO, "Image Information: ");
        MessageUtil.sendMessage((Plugin)this.getPlugin(), sender, MessageLevel.NORMAL, String.format("File Name: %s", filename));
        MessageUtil.sendMessage((Plugin)this.getPlugin(), sender, MessageLevel.NORMAL, String.format("Resolution: %dx%d", image.getWidth(), image.getHeight()));
        MessageUtil.sendMessage((Plugin)this.getPlugin(), sender, MessageLevel.NORMAL, String.format("Ingame Size: %dx%d", size.getKey(), size.getValue()));
        MessageUtil.sendMessage((Plugin)this.getPlugin(), sender, MessageLevel.NORMAL, (BaseComponent)actions);
        return null;
    }

    @Override
    public void help(CommandSender sender) {
        MessageUtil.sendMessage((Plugin)this.getPlugin(), sender, MessageLevel.NORMAL, "Displays information about an image.");
        MessageUtil.sendMessage((Plugin)this.getPlugin(), sender, MessageLevel.INFO, "Usage: /imagemap info <filename>");
    }

    @Override
    protected List<String> onTabComplete(CommandSender sender, String[] args) {
        if (args.length == 2) {
            return Utils.getMatches(args[1], new File(this.plugin.getDataFolder(), "images").list());
        }
        return Collections.emptyList();
    }
}

