/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.lib.updater;

import com.google.common.primitives.Ints;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.filoghost.holographicdisplays.plugin.lib.updater.InvalidVersionException;

class PluginVersion {
    private static Pattern VERSION_PATTERN = Pattern.compile("v?([0-9\\.]+)");
    private int[] versionNumbers;
    private boolean isDevBuild;

    protected PluginVersion(String input) throws InvalidVersionException {
        if (input == null) {
            throw new InvalidVersionException("input was null");
        }
        Matcher matcher = VERSION_PATTERN.matcher(input);
        if (!matcher.find()) {
            throw new InvalidVersionException("version pattern not found in \"" + input + "\"");
        }
        String version = matcher.group(1);
        String[] versionParts = version.replaceAll("[\\.]{2,}", ".").split("\\.");
        this.versionNumbers = new int[versionParts.length];
        for (int i = 0; i < versionParts.length; ++i) {
            try {
                this.versionNumbers[i] = Integer.parseInt(versionParts[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new InvalidVersionException("invalid number in \"" + input + "\"");
            }
        }
        this.isDevBuild = input.contains("SNAPSHOT");
    }

    protected boolean isNewerThan(PluginVersion other) {
        int longest = Math.max(this.versionNumbers.length, other.versionNumbers.length);
        for (int i = 0; i < longest; ++i) {
            int otherVersionPart;
            int thisVersionPart = i < this.versionNumbers.length ? this.versionNumbers[i] : 0;
            int diff = thisVersionPart - (otherVersionPart = i < other.versionNumbers.length ? other.versionNumbers[i] : 0);
            if (diff > 0) {
                return true;
            }
            if (diff >= 0) continue;
            return false;
        }
        return other.isDevBuild && !this.isDevBuild;
    }

    protected String getFormattedVersion() {
        return "v" + Ints.join((String)".", (int[])this.versionNumbers);
    }
}

