/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.lib.fcommons.command.sub.annotated;

import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Preconditions;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.CommandProperties;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.sub.SubCommandManager;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.sub.annotated.AnnotatedMethodSubCommand;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.sub.annotated.AnnotatedSubCommand;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.sub.annotated.Name;

public class AnnotatedSubCommandManager
extends SubCommandManager {
    private final SortedSet<AnnotatedSubCommand> subCommands = new TreeSet<AnnotatedSubCommand>(Comparator.comparing(AnnotatedSubCommand::getDisplayPriority).reversed().thenComparing(CommandProperties::getName, String.CASE_INSENSITIVE_ORDER));

    public AnnotatedSubCommandManager() {
        this.scanMethodsSubCommands(this.getClass());
    }

    private void scanMethodsSubCommands(Class<?> classToScan) {
        for (Method method : classToScan.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Name.class)) continue;
            AnnotatedMethodSubCommand subCommand = new AnnotatedMethodSubCommand(this, method);
            this.registerSubCommand(subCommand);
        }
    }

    @Override
    protected final AnnotatedSubCommand getSubCommandByName(String name) {
        for (AnnotatedSubCommand subCommand : this.subCommands) {
            if (!subCommand.getName().equalsIgnoreCase(name)) continue;
            return subCommand;
        }
        return null;
    }

    protected final Iterable<AnnotatedSubCommand> getSubCommands() {
        return this.subCommands;
    }

    protected final void registerSubCommand(AnnotatedSubCommand subCommand) {
        Preconditions.notNull(subCommand, "subCommand");
        subCommand.validate();
        Preconditions.checkState(this.getSubCommandByName(subCommand.getName()) == null, "subCommand with same name already registered");
        if (subCommand.getPermission() == null) {
            subCommand.setPermission(this.getDefaultSubCommandPermission(subCommand));
        }
        this.subCommands.add(subCommand);
    }

    protected String getDefaultSubCommandPermission(AnnotatedSubCommand subCommand) {
        return null;
    }
}

