/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.lib.fcommons.command.sub.annotated;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.CommandContext;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.sub.SubCommand;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.sub.SubCommandContext;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.sub.annotated.AnnotatedSubCommand;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.validation.CommandException;
import org.bukkit.command.CommandSender;

public class AnnotatedMethodSubCommand
extends AnnotatedSubCommand {
    private static final Map<Class<?>, MethodParameterProvider> parameterProviders = new HashMap();
    private final Object instance;
    private final Method method;
    private final List<MethodParameterProvider> methodParameterProviders;

    protected AnnotatedMethodSubCommand(Object instance, Method method) {
        this.instance = instance;
        this.method = method;
        this.method.setAccessible(true);
        this.methodParameterProviders = Arrays.stream(method.getParameterTypes()).map(paramType -> {
            MethodParameterProvider parameterProvider = parameterProviders.get(paramType);
            if (parameterProvider == null) {
                throw new IllegalArgumentException("Method " + method.getName() + " contains unsupported parameter type: " + paramType.getSimpleName());
            }
            return parameterProvider;
        }).collect(Collectors.toList());
    }

    @Override
    protected AnnotatedElement getAnnotatedElement() {
        return this.method;
    }

    @Override
    public void execute(CommandSender sender, String[] args, SubCommandContext context) throws CommandException {
        Object[] methodParameters = this.methodParameterProviders.stream().map(provider -> provider.get(context)).toArray();
        try {
            this.method.invoke(this.instance, methodParameters);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CommandException) {
                throw (CommandException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    static {
        parameterProviders.put(SubCommandContext.class, context -> context);
        parameterProviders.put(CommandSender.class, CommandContext::getSender);
        parameterProviders.put(SubCommand.class, SubCommandContext::getSubCommand);
        parameterProviders.put(String[].class, CommandContext::getArgs);
    }

    private static interface MethodParameterProvider {
        public Object get(SubCommandContext var1);
    }
}

