/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.lib.fcommons;

import java.util.Collection;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.MaterialsHelper;
import org.bukkit.Bukkit;
import org.bukkit.Material;

public final class Preconditions {
    public static void notNull(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
    }

    public static void notNull(Object object, String objectName) {
        if (object == null) {
            throw new NullPointerException(objectName + " cannot be null");
        }
    }

    public static void notEmpty(String string, String objectName) {
        Preconditions.notNull(string, objectName);
        if (string.isEmpty()) {
            throw new IllegalArgumentException(objectName + " cannot be empty");
        }
    }

    public static void notEmpty(Collection<?> collection, String objectName) {
        Preconditions.notNull(collection, objectName);
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(objectName + " cannot be empty");
        }
    }

    public static void notEmpty(Object[] array, String objectName) {
        Preconditions.notNull(array, objectName);
        if (array.length == 0) {
            throw new IllegalArgumentException(objectName + " cannot be empty");
        }
    }

    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression, String errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean expression, String errorMessage) {
        if (!expression) {
            throw new IllegalStateException(errorMessage);
        }
    }

    public static void checkIndex(int index, int size, String objectName) {
        Preconditions.checkArgument(size >= 0, "size cannot be negative");
        if (index < 0) {
            throw new IndexOutOfBoundsException(objectName + " (" + index + ") cannot be negative");
        }
        if (index >= size) {
            throw new IndexOutOfBoundsException(objectName + " (" + index + ") must be less than size (" + size + ")");
        }
    }

    public static void checkArgumentNotAir(Material material, String objectName) {
        Preconditions.notNull(material, objectName);
        if (MaterialsHelper.isAir(material)) {
            throw new IllegalArgumentException(objectName + " cannot be " + material);
        }
    }

    public static void checkMainThread(String errorMessage) {
        Preconditions.checkState(Bukkit.isPrimaryThread(), errorMessage);
    }
}

