/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.config.upgrade;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import me.filoghost.holographicdisplays.plugin.config.ConfigManager;
import me.filoghost.holographicdisplays.plugin.config.upgrade.LegacyUpgradeTask;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Preconditions;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.exception.ConfigException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.logging.ErrorCollector;

public abstract class LegacyUpgrade
implements LegacyUpgradeTask {
    protected final ConfigManager configManager;
    private final ErrorCollector errorCollector;
    private final Path rootDataFolder;
    private final Path backupsFolder;

    public LegacyUpgrade(ConfigManager configManager, ErrorCollector errorCollector) {
        this.configManager = configManager;
        this.errorCollector = errorCollector;
        this.rootDataFolder = configManager.getRootDataFolder();
        this.backupsFolder = this.rootDataFolder.resolve("old-files");
    }

    protected abstract Path getFile();

    public final void tryRun() {
        this.tryRun(this.getFile(), this);
    }

    protected final void tryRun(Path file, LegacyUpgradeTask task) {
        try {
            task.run();
        }
        catch (IOException | ConfigException e) {
            this.errorCollector.add(e, "error while upgrading \"" + this.configManager.formatPath(file) + "\" to the new format");
        }
    }

    protected final void createBackupFile(Path file) {
        Preconditions.checkArgument(file.startsWith(this.rootDataFolder), "file is outside data folder");
        Preconditions.checkArgument(!file.startsWith(this.backupsFolder), "file is inside backups folder");
        Path pathFromRootDataFolderToFile = file.subpath(this.rootDataFolder.getNameCount(), file.getNameCount());
        Path backupFile = this.backupsFolder.resolve(pathFromRootDataFolderToFile);
        int copyIndex = 1;
        while (Files.isRegularFile(backupFile, new LinkOption[0])) {
            backupFile = this.getAlternativeCopyFile(backupFile, copyIndex);
            ++copyIndex;
        }
        try {
            Files.createDirectories(backupFile.getParent(), new FileAttribute[0]);
            Files.copy(file, backupFile, new CopyOption[0]);
        }
        catch (IOException e) {
            this.errorCollector.add(e, "error while copying file \"" + this.configManager.formatPath(file) + "\" to \"" + this.configManager.formatPath(this.backupsFolder) + "\"");
        }
        Path readMeFile = this.backupsFolder.resolve("README.txt");
        if (!Files.isRegularFile(readMeFile, new LinkOption[0])) {
            try {
                Files.write(readMeFile, Collections.singletonList("This folder is used to backup configuration files before automatically upgrading them to a newer format."), new OpenOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private Path getAlternativeCopyFile(Path file, int copyIndex) {
        String extensionWithSeparator;
        String fileNameWithoutExtension;
        String fileName = file.getFileName().toString();
        int extensionBeginIndex = fileName.lastIndexOf(46);
        if (extensionBeginIndex >= 0) {
            fileNameWithoutExtension = fileName.substring(0, extensionBeginIndex);
            extensionWithSeparator = fileName.substring(extensionBeginIndex);
        } else {
            fileNameWithoutExtension = fileName;
            extensionWithSeparator = "";
        }
        return file.resolveSibling(fileNameWithoutExtension + " (" + copyIndex + ")" + extensionWithSeparator);
    }
}

