/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.config;

import java.util.Arrays;
import java.util.List;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.Config;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.mapped.MappedConfig;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.mapped.Path;
import org.jetbrains.annotations.NotNull;

public class SettingsModel
implements MappedConfig {
    @Path(value="space-between-lines")
    double spaceBetweenLines = 0.02;
    @Path(value="holograms-view-range")
    int viewRange = 48;
    @Path(value="quick-edit-commands")
    boolean quickEditCommands = true;
    @Path(value="placeholders.PlaceholderAPI.enabled")
    boolean placeholderAPIEnabled = true;
    @Path(value="placeholders.PlaceholderAPI.expand-short-format")
    boolean placeholderAPIShortFormat = true;
    @Path(value="placeholders.PlaceholderAPI.default-refresh-interval-ticks")
    int placeholderAPIDefaultRefreshIntervalTicks = 200;
    @Path(value="image-rendering.solid-pixel")
    String imageRenderingSolidPixel = "\u2588";
    @Path(value="image-rendering.transparent-pixel")
    String imageRenderingTransparentPixel = "&7 \u23b9 ";
    @Path(value="bungee.refresh-seconds")
    int bungeeRefreshSeconds = 3;
    @Path(value="bungee.use-RedisBungee")
    boolean useRedisBungee = false;
    @Path(value="bungee.pinger.enable")
    boolean pingerEnable = false;
    @Path(value="bungee.pinger.timeout")
    int pingerTimeout = 500;
    @Path(value="bungee.pinger.offline-motd")
    String pingerOfflineMotd = "&cOffline, couldn't get the MOTD";
    @Path(value="bungee.pinger.status.online")
    String pingerStatusOnline = "&aOnline";
    @Path(value="bungee.pinger.status.offline")
    String pingerStatusOffline = "&cOffline";
    @Path(value="bungee.pinger.motd-remove-leading-trailing-spaces")
    boolean pingerTrimMotd = true;
    @Path(value="bungee.pinger.servers")
    List<String> pingerServers = Arrays.asList("hub: 127.0.0.1:25565", "games: 127.0.0.1:25566");
    @Path(value="time.format")
    String timeFormat = "H:mm";
    @Path(value="time.zone")
    String timeZone = "GMT+1";
    @Path(value="update-notification")
    boolean updateNotification = true;
    @Path(value="debug")
    boolean debug = false;

    @Override
    @NotNull
    public List<String> getHeader() {
        return Arrays.asList("", "Plugin page: https://dev.bukkit.org/projects/holographic-displays", "", "Created by filoghost.", "");
    }

    @Override
    public boolean beforeLoad(Config rawConfig) {
        boolean modified = false;
        if (rawConfig.contains("images") && !rawConfig.contains("image-rendering")) {
            String oldTransparencyColor = rawConfig.getString("images.transparency.color");
            String oldTransparencySpace = rawConfig.getString("images.transparency.space");
            String oldSolidSymbol = rawConfig.getString("images.symbol");
            if (oldTransparencyColor != null && oldTransparencySpace != null) {
                rawConfig.setString("image-rendering.transparent-pixel", oldTransparencyColor + oldTransparencySpace);
                modified = true;
            }
            if (oldSolidSymbol != null) {
                rawConfig.setString("image-rendering.solid-pixel", oldSolidSymbol);
                modified = true;
            }
        }
        List<String> pathsToRemove = Arrays.asList("vertical-spacing", "time-format", "bungee-refresh-seconds", "using-RedisBungee", "bungee-online-format", "bungee-offline-format", "precise-hologram-movement", "images");
        for (String path : pathsToRemove) {
            if (!rawConfig.contains(path)) continue;
            rawConfig.remove(path);
            modified = true;
        }
        return modified;
    }
}

