/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.config;

import java.util.ArrayList;
import java.util.List;
import me.filoghost.holographicdisplays.api.Position;
import me.filoghost.holographicdisplays.plugin.config.InternalHologramLineParser;
import me.filoghost.holographicdisplays.plugin.config.InternalHologramLoadException;
import me.filoghost.holographicdisplays.plugin.internal.hologram.InternalHologram;
import me.filoghost.holographicdisplays.plugin.internal.hologram.InternalHologramLine;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.collection.CollectionUtils;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.ConfigSection;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.exception.ConfigValueException;

public class InternalHologramConfig {
    private final String name;
    private final ConfigSection configSection;

    public InternalHologramConfig(String name, ConfigSection configSection) {
        this.name = name;
        this.configSection = configSection;
    }

    public InternalHologramConfig(InternalHologram hologram) {
        this.name = hologram.getName();
        this.configSection = new ConfigSection();
        List<String> serializedLines = this.serializeLines(hologram);
        ConfigSection positionConfigSection = this.serializePosition(hologram.getPosition());
        this.configSection.setStringList("lines", serializedLines);
        this.configSection.setConfigSection("position", positionConfigSection);
    }

    public String getName() {
        return this.name;
    }

    public ConfigSection getSerializedConfigSection() {
        return this.configSection;
    }

    private List<String> serializeLines(InternalHologram hologram) {
        return CollectionUtils.toArrayList(hologram.getLines(), InternalHologramLine::getSerializedString);
    }

    public List<InternalHologramLine> deserializeLines() throws InternalHologramLoadException {
        List<String> serializedLines = this.configSection.getStringList("lines");
        if (serializedLines == null || serializedLines.size() == 0) {
            throw new InternalHologramLoadException("at least one line is required");
        }
        ArrayList<InternalHologramLine> lines = new ArrayList<InternalHologramLine>();
        for (String serializedLine : serializedLines) {
            try {
                lines.add(InternalHologramLineParser.parseLine(serializedLine));
            }
            catch (InternalHologramLoadException e) {
                throw new InternalHologramLoadException("invalid line: " + e.getMessage(), e);
            }
        }
        return lines;
    }

    private ConfigSection serializePosition(Position position) {
        ConfigSection positionConfigSection = new ConfigSection();
        positionConfigSection.setString("world", position.getWorldName());
        positionConfigSection.setDouble("x", position.getX());
        positionConfigSection.setDouble("y", position.getY());
        positionConfigSection.setDouble("z", position.getZ());
        return positionConfigSection;
    }

    public Position deserializePosition() throws InternalHologramLoadException {
        ConfigSection positionConfigSection = this.configSection.getConfigSection("position");
        if (positionConfigSection == null) {
            throw new InternalHologramLoadException("no position set");
        }
        try {
            String worldName = positionConfigSection.getRequiredString("world");
            double x = positionConfigSection.getRequiredDouble("x");
            double y = positionConfigSection.getRequiredDouble("y");
            double z = positionConfigSection.getRequiredDouble("z");
            return Position.of(worldName, x, y, z);
        }
        catch (ConfigValueException e) {
            throw new InternalHologramLoadException("invalid position attribute \"" + e.getConfigPath() + "\"", e);
        }
    }
}

