/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.commands.subs;

import me.filoghost.holographicdisplays.plugin.commands.HologramCommandManager;
import me.filoghost.holographicdisplays.plugin.commands.InternalHologramEditor;
import me.filoghost.holographicdisplays.plugin.commands.subs.LineEditingCommand;
import me.filoghost.holographicdisplays.plugin.commands.subs.QuickEditCommand;
import me.filoghost.holographicdisplays.plugin.event.InternalHologramChangeEvent;
import me.filoghost.holographicdisplays.plugin.format.ColorScheme;
import me.filoghost.holographicdisplays.plugin.internal.hologram.InternalHologram;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.sub.SubCommandContext;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.validation.CommandException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.validation.CommandValidate;
import org.bukkit.command.CommandSender;

public class RemoveLineCommand
extends LineEditingCommand
implements QuickEditCommand {
    private final HologramCommandManager commandManager;
    private final InternalHologramEditor hologramEditor;

    public RemoveLineCommand(HologramCommandManager commandManager, InternalHologramEditor hologramEditor) {
        super("removeLine", new String[0]);
        this.setMinArgs(2);
        this.setUsageArgs("<hologram> <lineNumber>");
        this.setDescription("Removes a line from a hologram.");
        this.commandManager = commandManager;
        this.hologramEditor = hologramEditor;
    }

    @Override
    public void execute(CommandSender sender, String[] args, SubCommandContext context) throws CommandException {
        InternalHologram hologram = this.hologramEditor.getExistingHologram(args[0]);
        int lineNumber = CommandValidate.parseInteger(args[1]);
        int linesAmount = hologram.getLines().size();
        CommandValidate.check(lineNumber >= 1 && lineNumber <= linesAmount, "The line number must be between 1 and " + linesAmount + ".");
        int index = lineNumber - 1;
        CommandValidate.check(linesAmount >= 2, "A hologram must always have at least 1 line. If you want to delete it, use /" + context.getRootLabel() + " delete.");
        hologram.removeLine(index);
        this.hologramEditor.saveChanges(hologram, InternalHologramChangeEvent.ChangeType.EDIT_LINES);
        sender.sendMessage(ColorScheme.PRIMARY + "Line " + lineNumber + " removed.");
        this.commandManager.sendQuickEditCommands(context, hologram);
    }

    @Override
    public String getActionName() {
        return "Remove";
    }
}

