/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.commands.subs;

import java.util.ArrayList;
import me.filoghost.holographicdisplays.api.Position;
import me.filoghost.holographicdisplays.plugin.commands.HologramSubCommand;
import me.filoghost.holographicdisplays.plugin.commands.InternalHologramEditor;
import me.filoghost.holographicdisplays.plugin.format.DisplayFormat;
import me.filoghost.holographicdisplays.plugin.internal.hologram.InternalHologram;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.sub.SubCommandContext;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.validation.CommandException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.validation.CommandValidate;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class NearCommand
extends HologramSubCommand {
    private final InternalHologramEditor hologramEditor;

    public NearCommand(InternalHologramEditor hologramEditor) {
        super("near", new String[0]);
        this.setMinArgs(1);
        this.setUsageArgs("<radius>");
        this.setDescription("Get a list of near holograms.");
        this.hologramEditor = hologramEditor;
    }

    @Override
    public void execute(CommandSender sender, String[] args, SubCommandContext context) throws CommandException {
        Player player = CommandValidate.getPlayerSender(sender);
        int radius = CommandValidate.parseInteger(args[0]);
        CommandValidate.check(radius > 0, "Radius must be at least 1.");
        ArrayList<InternalHologram> nearHolograms = new ArrayList<InternalHologram>();
        for (InternalHologram hologram : this.hologramEditor.getHolograms()) {
            Position position = hologram.getPosition();
            if (!position.isInSameWorld((Entity)player) || !(position.distance((Entity)player) <= (double)radius)) continue;
            nearHolograms.add(hologram);
        }
        CommandValidate.check(!nearHolograms.isEmpty(), "There are no holograms in the given radius.");
        DisplayFormat.sendTitle((CommandSender)player, "Near holograms");
        for (InternalHologram nearHologram : nearHolograms) {
            DisplayFormat.sendHologramSummary((CommandSender)player, nearHologram, false);
        }
    }
}

