/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.commands.subs;

import me.filoghost.holographicdisplays.plugin.commands.HologramSubCommand;
import me.filoghost.holographicdisplays.plugin.commands.InternalHologramEditor;
import me.filoghost.holographicdisplays.plugin.event.InternalHologramChangeEvent;
import me.filoghost.holographicdisplays.plugin.format.ColorScheme;
import me.filoghost.holographicdisplays.plugin.internal.hologram.InternalHologram;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.sub.SubCommandContext;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.validation.CommandException;
import org.bukkit.command.CommandSender;

public class CopyCommand
extends HologramSubCommand {
    private final InternalHologramEditor hologramEditor;

    public CopyCommand(InternalHologramEditor hologramEditor) {
        super("copy", new String[0]);
        this.setMinArgs(2);
        this.setUsageArgs("<fromHologram> <toHologram>");
        this.setDescription("Copies the content from a hologram to another one, replacing it.");
        this.hologramEditor = hologramEditor;
    }

    @Override
    public void execute(CommandSender sender, String[] args, SubCommandContext context) throws CommandException {
        InternalHologram fromHologram = this.hologramEditor.getExistingHologram(args[0]);
        InternalHologram toHologram = this.hologramEditor.getExistingHologram(args[1]);
        toHologram.setLines(fromHologram.getLines());
        this.hologramEditor.saveChanges(toHologram, InternalHologramChangeEvent.ChangeType.EDIT_LINES);
        sender.sendMessage(ColorScheme.PRIMARY + "Lines of hologram \"" + fromHologram.getName() + "\" copied to hologram \"" + toHologram.getName() + "\".");
    }
}

