/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin;

import java.util.List;
import java.util.concurrent.TimeUnit;
import me.filoghost.holographicdisplays.api.HolographicDisplaysAPI;
import me.filoghost.holographicdisplays.api.Position;
import me.filoghost.holographicdisplays.core.HolographicDisplaysCore;
import me.filoghost.holographicdisplays.plugin.bridge.bungeecord.BungeeServerTracker;
import me.filoghost.holographicdisplays.plugin.bridge.placeholderapi.PlaceholderAPIHook;
import me.filoghost.holographicdisplays.plugin.commands.HologramCommandManager;
import me.filoghost.holographicdisplays.plugin.commands.InternalHologramEditor;
import me.filoghost.holographicdisplays.plugin.config.ConfigManager;
import me.filoghost.holographicdisplays.plugin.config.InternalHologramConfig;
import me.filoghost.holographicdisplays.plugin.config.InternalHologramLoadException;
import me.filoghost.holographicdisplays.plugin.config.Settings;
import me.filoghost.holographicdisplays.plugin.config.upgrade.AnimationsLegacyUpgrade;
import me.filoghost.holographicdisplays.plugin.config.upgrade.DatabaseLegacyUpgrade;
import me.filoghost.holographicdisplays.plugin.config.upgrade.SymbolsLegacyUpgrade;
import me.filoghost.holographicdisplays.plugin.internal.hologram.InternalHologram;
import me.filoghost.holographicdisplays.plugin.internal.hologram.InternalHologramLine;
import me.filoghost.holographicdisplays.plugin.internal.hologram.InternalHologramManager;
import me.filoghost.holographicdisplays.plugin.internal.placeholder.AnimationPlaceholderFactory;
import me.filoghost.holographicdisplays.plugin.internal.placeholder.DefaultPlaceholders;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.FCommonsPlugin;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.FeatureSupport;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.logging.ErrorCollector;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.logging.Log;
import me.filoghost.holographicdisplays.plugin.lib.metrics.MetricsLite;
import me.filoghost.holographicdisplays.plugin.lib.updater.UpdateChecker;
import me.filoghost.holographicdisplays.plugin.listener.UpdateNotificationListener;
import me.filoghost.holographicdisplays.plugin.log.PrintableErrorCollector;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.plugin.Plugin;

public class HolographicDisplays
extends FCommonsPlugin {
    private static HolographicDisplays instance;
    private HolographicDisplaysCore core;
    private HolographicDisplaysAPI api;
    private ConfigManager configManager;
    private BungeeServerTracker bungeeServerTracker;
    private InternalHologramManager internalHologramManager;
    private InternalHologramEditor internalHologramEditor;

    @Override
    public void onCheckedEnable() throws FCommonsPlugin.PluginEnableException {
        if (instance != null || System.getProperty("HolographicDisplaysLoaded") != null) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[HolographicDisplays] Please do not use /reload or plugin reloaders. Use the command \"/holograms reload\" instead. You will receive no support for doing this operation.");
        }
        System.setProperty("HolographicDisplaysLoaded", "true");
        instance = this;
        if (!FeatureSupport.CHAT_COMPONENTS) {
            throw new FCommonsPlugin.PluginEnableException("Holographic Displays requires the new chat API.", "You are probably running CraftBukkit instead of Spigot.");
        }
        if (this.getCommand("holograms") == null) {
            throw new FCommonsPlugin.PluginEnableException("Holographic Displays was unable to register the command \"holograms\".", "This can be caused by edits to plugin.yml or other plugins.");
        }
        PrintableErrorCollector errorCollector = new PrintableErrorCollector();
        this.core = new HolographicDisplaysCore();
        this.core.enable((Plugin)this, errorCollector);
        this.api = HolographicDisplaysAPI.get((Plugin)this);
        this.configManager = new ConfigManager(this.getDataFolder().toPath());
        this.bungeeServerTracker = new BungeeServerTracker((Plugin)this);
        this.internalHologramManager = new InternalHologramManager(this.api);
        new SymbolsLegacyUpgrade(this.configManager, errorCollector).tryRun();
        new AnimationsLegacyUpgrade(this.configManager, errorCollector).tryRun();
        new DatabaseLegacyUpgrade(this.configManager, errorCollector).tryRun();
        this.load(errorCollector);
        this.internalHologramEditor = new InternalHologramEditor(this.internalHologramManager, this.configManager);
        new HologramCommandManager(this, this.internalHologramEditor).register(this);
        PlaceholderAPIHook.setup();
        int bStatsPluginID = 3123;
        new MetricsLite((Plugin)this, bStatsPluginID);
        if (errorCollector.hasErrors()) {
            errorCollector.logToConsole();
            Bukkit.getScheduler().runTaskLater((Plugin)this, errorCollector::logSummaryToConsole, 10L);
        }
        if (Settings.updateNotification) {
            int bukkitPluginID = 75097;
            UpdateChecker.run((Plugin)this, bukkitPluginID, newVersion -> {
                this.registerListener(new UpdateNotificationListener(newVersion));
                Log.info("Found a new version available: " + newVersion);
                Log.info("Download it on Bukkit Dev:");
                Log.info("https://dev.bukkit.org/projects/holographic-displays");
            });
        }
    }

    public void load(ErrorCollector errorCollector) {
        this.internalHologramManager.deleteHolograms();
        this.configManager.reloadStaticReplacements(errorCollector);
        this.configManager.reloadMainSettings(errorCollector);
        this.core.setSpaceBetweenHologramLines(Settings.spaceBetweenLines);
        this.core.setMaxViewRange(Settings.viewRange);
        AnimationPlaceholderFactory animationPlaceholderFactory = this.configManager.loadAnimations(errorCollector);
        DefaultPlaceholders.resetAndRegister(this.api, animationPlaceholderFactory, this.bungeeServerTracker);
        this.bungeeServerTracker.restart(Settings.bungeeRefreshSeconds, TimeUnit.SECONDS);
        List<InternalHologramConfig> hologramConfigs = this.configManager.readHologramDatabase(errorCollector);
        for (InternalHologramConfig hologramConfig : hologramConfigs) {
            try {
                List<InternalHologramLine> lines = hologramConfig.deserializeLines();
                Position position = hologramConfig.deserializePosition();
                InternalHologram hologram = this.internalHologramManager.createHologram(hologramConfig.getName(), position);
                hologram.addLines(lines);
            }
            catch (InternalHologramLoadException e) {
                errorCollector.add(e, "error while loading hologram \"" + hologramConfig.getName() + "\"");
            }
        }
    }

    public void onDisable() {
        this.core.disable();
    }

    public static HolographicDisplays getInstance() {
        return instance;
    }

    public InternalHologramEditor getInternalHologramEditor() {
        return this.internalHologramEditor;
    }

    public InternalHologramManager getInternalHologramManager() {
        return this.internalHologramManager;
    }
}

