/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.nms.v1_11_R1;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.filoghost.holographicdisplays.nms.common.EntityID;
import me.filoghost.holographicdisplays.nms.common.FallbackEntityIDGenerator;
import me.filoghost.holographicdisplays.nms.common.NMSManager;
import me.filoghost.holographicdisplays.nms.common.PacketListener;
import me.filoghost.holographicdisplays.nms.common.entity.ClickableNMSPacketEntity;
import me.filoghost.holographicdisplays.nms.common.entity.ItemNMSPacketEntity;
import me.filoghost.holographicdisplays.nms.common.entity.TextNMSPacketEntity;
import me.filoghost.holographicdisplays.nms.v1_11_R1.DataWatcherKey;
import me.filoghost.holographicdisplays.nms.v1_11_R1.InboundPacketHandler;
import me.filoghost.holographicdisplays.nms.v1_11_R1.VersionClickableNMSPacketEntity;
import me.filoghost.holographicdisplays.nms.v1_11_R1.VersionItemNMSPacketEntity;
import me.filoghost.holographicdisplays.nms.v1_11_R1.VersionTextNMSPacketEntity;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.logging.ErrorCollector;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.logging.Log;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.reflection.ReflectField;
import net.minecraft.server.v1_11_R1.Entity;
import net.minecraft.server.v1_11_R1.NetworkManager;
import net.minecraft.server.v1_11_R1.PlayerConnection;
import org.bukkit.craftbukkit.v1_11_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class VersionNMSManager
implements NMSManager {
    private static final ReflectField<Integer> ENTITY_ID_COUNTER_FIELD = ReflectField.lookup(Integer.TYPE, Entity.class, "entityCount");
    private final Supplier<Integer> fallbackEntityIDGenerator = new FallbackEntityIDGenerator();
    private final Supplier<Integer> entityIDGenerator;

    public VersionNMSManager(ErrorCollector errorCollector) {
        this.entityIDGenerator = this.getEntityIDGenerator(errorCollector);
        DataWatcherKey.ENTITY_STATUS.getIndex();
    }

    private Supplier<Integer> getEntityIDGenerator(ErrorCollector errorCollector) {
        try {
            this.testStaticFieldReadWrite(ENTITY_ID_COUNTER_FIELD);
            return () -> {
                try {
                    int nmsEntityIDCounter = ENTITY_ID_COUNTER_FIELD.getStatic();
                    ENTITY_ID_COUNTER_FIELD.setStatic(nmsEntityIDCounter + 1);
                    return nmsEntityIDCounter;
                }
                catch (ReflectiveOperationException e) {
                    return this.fallbackEntityIDGenerator.get();
                }
            };
        }
        catch (ReflectiveOperationException e) {
            errorCollector.add(e, "Could not get the NMS entity ID generator. There is a small chance of entity ID conflicts, causing client-side issues on single entities.");
            return this.fallbackEntityIDGenerator;
        }
    }

    private <T> void testStaticFieldReadWrite(ReflectField<T> field) throws ReflectiveOperationException {
        T value = field.getStatic();
        field.setStatic(value);
    }

    private EntityID newEntityID() {
        return new EntityID(this.entityIDGenerator);
    }

    @Override
    public TextNMSPacketEntity newTextPacketEntity() {
        return new VersionTextNMSPacketEntity(this.newEntityID());
    }

    @Override
    public ItemNMSPacketEntity newItemPacketEntity() {
        return new VersionItemNMSPacketEntity(this.newEntityID(), this.newEntityID());
    }

    @Override
    public ClickableNMSPacketEntity newClickablePacketEntity() {
        return new VersionClickableNMSPacketEntity(this.newEntityID());
    }

    @Override
    public void injectPacketListener(Player player, PacketListener packetListener) {
        this.modifyPipeline(player, pipeline -> {
            ChannelHandler currentListener = pipeline.get("holographic_displays_listener");
            if (currentListener != null) {
                pipeline.remove("holographic_displays_listener");
            }
            pipeline.addBefore("packet_handler", "holographic_displays_listener", (ChannelHandler)new InboundPacketHandler(player, packetListener));
        });
    }

    @Override
    public void uninjectPacketListener(Player player) {
        this.modifyPipeline(player, pipeline -> {
            ChannelHandler currentListener = pipeline.get("holographic_displays_listener");
            if (currentListener != null) {
                pipeline.remove("holographic_displays_listener");
            }
        });
    }

    private void modifyPipeline(Player player, Consumer<ChannelPipeline> pipelineModifierTask) {
        PlayerConnection playerConnection = ((CraftPlayer)player).getHandle().playerConnection;
        NetworkManager networkManager = playerConnection.a();
        Channel channel = networkManager.channel;
        if (channel == null) {
            return;
        }
        EventLoop eventLoop = channel.eventLoop();
        Runnable safeModifierTask = () -> {
            if (!player.isOnline()) {
                return;
            }
            try {
                pipelineModifierTask.accept(channel.pipeline());
            }
            catch (Exception e) {
                Log.warning("Unexpected error while modifying the channel pipeline.", e);
            }
        };
        if (eventLoop.inEventLoop()) {
            safeModifierTask.run();
        } else {
            eventLoop.execute(safeModifierTask);
        }
    }
}

