/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.tracking;

import java.util.Objects;
import me.filoghost.holographicdisplays.core.tick.CachedPlayer;
import me.filoghost.holographicdisplays.core.tracking.DisplayText;
import me.filoghost.holographicdisplays.core.tracking.Viewer;
import me.filoghost.holographicdisplays.nms.common.IndividualTextPacketGroup;
import org.jetbrains.annotations.Nullable;

class TextLineViewer
extends Viewer {
    private final DisplayText displayText;
    private String individualText;
    private String lastSentText;

    TextLineViewer(CachedPlayer player, DisplayText displayText) {
        super(player);
        this.displayText = displayText;
    }

    public void sendTextPackets(IndividualTextPacketGroup packets) {
        String text;
        this.lastSentText = text = this.getOrComputeText();
        this.sendIndividualPackets(packets, text);
    }

    public void sendTextPacketsIfNecessary(IndividualTextPacketGroup packets) {
        String text = this.getOrComputeText();
        if (Objects.equals(this.lastSentText, text)) {
            return;
        }
        this.lastSentText = text;
        this.sendIndividualPackets(packets, text);
    }

    @Nullable
    private String getOrComputeText() {
        if (this.displayText.containsIndividualPlaceholders()) {
            if (this.individualText == null) {
                this.individualText = this.displayText.computeIndividualText(this);
            }
            return this.individualText;
        }
        this.individualText = null;
        return this.displayText.getGlobalText();
    }

    public boolean updateIndividualText() {
        String individualText = this.displayText.computeIndividualText(this);
        if (!Objects.equals(this.individualText, individualText)) {
            this.individualText = individualText;
            return true;
        }
        return false;
    }
}

