/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.tracking;

import java.util.Objects;
import me.filoghost.holographicdisplays.core.base.BaseTextHologramLine;
import me.filoghost.holographicdisplays.core.listener.LineClickListener;
import me.filoghost.holographicdisplays.core.placeholder.tracking.ActivePlaceholderTracker;
import me.filoghost.holographicdisplays.core.tick.CachedPlayer;
import me.filoghost.holographicdisplays.core.tracking.ClickableLineTracker;
import me.filoghost.holographicdisplays.core.tracking.DisplayText;
import me.filoghost.holographicdisplays.core.tracking.TextLineViewer;
import me.filoghost.holographicdisplays.core.tracking.Viewers;
import me.filoghost.holographicdisplays.nms.common.IndividualTextPacketGroup;
import me.filoghost.holographicdisplays.nms.common.NMSManager;
import me.filoghost.holographicdisplays.nms.common.entity.TextNMSPacketEntity;
import org.jetbrains.annotations.MustBeInvokedByOverriders;

public class TextLineTracker
extends ClickableLineTracker<TextLineViewer> {
    private final BaseTextHologramLine line;
    private final TextNMSPacketEntity textEntity;
    private final DisplayText displayText;
    private boolean displayTextChanged;

    public TextLineTracker(BaseTextHologramLine line, NMSManager nmsManager, LineClickListener lineClickListener, ActivePlaceholderTracker placeholderTracker) {
        super(line, nmsManager, lineClickListener);
        this.line = line;
        this.textEntity = nmsManager.newTextPacketEntity();
        this.displayText = new DisplayText(placeholderTracker);
    }

    @Override
    public BaseTextHologramLine getLine() {
        return this.line;
    }

    @Override
    protected boolean updatePlaceholders() {
        boolean placeholdersChanged = this.displayText.updateReplacements(this.getViewers());
        if (placeholdersChanged) {
            this.displayTextChanged = true;
        }
        return placeholdersChanged;
    }

    @Override
    protected TextLineViewer createViewer(CachedPlayer cachedPlayer) {
        return new TextLineViewer(cachedPlayer, this.displayText);
    }

    @Override
    @MustBeInvokedByOverriders
    protected void detectChanges() {
        super.detectChanges();
        String displayText = this.line.getText();
        if (!Objects.equals(this.displayText.getUnreplacedText(), displayText)) {
            this.displayText.setUnreplacedText(displayText);
            this.displayTextChanged = true;
        }
        boolean allowPlaceholders = this.line.isAllowPlaceholders();
        if (this.displayText.isAllowPlaceholders() != allowPlaceholders) {
            this.displayText.setAllowPlaceholders(allowPlaceholders);
            this.displayTextChanged = true;
        }
    }

    @Override
    @MustBeInvokedByOverriders
    protected void clearDetectedChanges() {
        super.clearDetectedChanges();
        this.displayTextChanged = false;
    }

    @Override
    @MustBeInvokedByOverriders
    protected void sendSpawnPackets(Viewers<TextLineViewer> viewers) {
        super.sendSpawnPackets(viewers);
        IndividualTextPacketGroup spawnPackets = this.textEntity.newSpawnPackets(this.positionCoordinates);
        viewers.forEach(viewer -> viewer.sendTextPackets(spawnPackets));
    }

    @Override
    @MustBeInvokedByOverriders
    protected void sendDestroyPackets(Viewers<TextLineViewer> viewers) {
        super.sendDestroyPackets(viewers);
        viewers.sendPackets(this.textEntity.newDestroyPackets());
    }

    @Override
    protected void sendChangesPackets(Viewers<TextLineViewer> viewers) {
        super.sendChangesPackets(viewers);
        if (this.displayTextChanged) {
            IndividualTextPacketGroup changePackets = this.textEntity.newChangePackets();
            viewers.forEach(viewer -> viewer.sendTextPacketsIfNecessary(changePackets));
        }
    }

    @Override
    @MustBeInvokedByOverriders
    protected void sendPositionChangePackets(Viewers<TextLineViewer> viewers) {
        super.sendPositionChangePackets(viewers);
        viewers.sendPackets(this.textEntity.newTeleportPackets(this.positionCoordinates));
    }

    @Override
    protected double getViewRange() {
        return 64.0;
    }
}

