/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.tick;

import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class CachedPlayer {
    private final Player player;
    private Location location;
    private boolean movedLastTick;

    public CachedPlayer(Player player) {
        this.player = player;
    }

    void onTick() {
        Location newLocation = this.player.getLocation();
        this.movedLastTick = this.isDifferentPosition(this.location, newLocation);
        this.location = newLocation;
    }

    private boolean isDifferentPosition(Location oldLocation, Location newLocation) {
        if (oldLocation == null) {
            return true;
        }
        return newLocation.getWorld() != oldLocation.getWorld() || newLocation.getX() != oldLocation.getX() || newLocation.getY() != oldLocation.getY() || newLocation.getZ() != oldLocation.getZ();
    }

    public Player getBukkitPlayer() {
        return this.player;
    }

    @Nullable
    public Location getLocation() {
        return this.location;
    }

    public boolean isMovedLastTick() {
        return this.movedLastTick;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CachedPlayer other = (CachedPlayer)obj;
        return this.player.equals(other.player);
    }

    public int hashCode() {
        return this.player.hashCode();
    }
}

