/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.api.current;

import me.filoghost.holographicdisplays.api.hologram.PlaceholderSetting;
import me.filoghost.holographicdisplays.api.hologram.line.HologramLineClickListener;
import me.filoghost.holographicdisplays.api.hologram.line.TextHologramLine;
import me.filoghost.holographicdisplays.core.CorePreconditions;
import me.filoghost.holographicdisplays.core.api.current.APIHologram;
import me.filoghost.holographicdisplays.core.api.current.APIHologramLine;
import me.filoghost.holographicdisplays.core.api.current.SimpleHologramLineClickEvent;
import me.filoghost.holographicdisplays.core.base.BaseTextHologramLine;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

class APITextHologramLine
extends BaseTextHologramLine
implements TextHologramLine,
APIHologramLine {
    private final APIHologram hologram;
    private HologramLineClickListener clickListener;

    APITextHologramLine(APIHologram hologram, String text) {
        super(hologram, text);
        this.hologram = hologram;
    }

    @Override
    public boolean isAllowPlaceholders() {
        return this.hologram.getPlaceholderSetting() == PlaceholderSetting.ENABLE_ALL;
    }

    @Override
    public void setClickListener(@Nullable HologramLineClickListener clickListener) {
        CorePreconditions.checkMainThread();
        this.checkNotDeleted();
        this.clickListener = clickListener;
        this.setChanged();
    }

    @Override
    @Nullable
    public HologramLineClickListener getClickListener() {
        return this.clickListener;
    }

    @Override
    public boolean hasClickCallback() {
        return this.clickListener != null;
    }

    @Override
    protected void invokeExternalClickCallback(Player player) {
        if (this.clickListener != null) {
            this.clickListener.onClick(new SimpleHologramLineClickEvent(player));
        }
    }
}

