/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.api.current;

import me.filoghost.holographicdisplays.api.Position;
import me.filoghost.holographicdisplays.api.hologram.Hologram;
import me.filoghost.holographicdisplays.api.hologram.PlaceholderSetting;
import me.filoghost.holographicdisplays.core.CorePreconditions;
import me.filoghost.holographicdisplays.core.api.current.APIHologramLine;
import me.filoghost.holographicdisplays.core.api.current.APIHologramLines;
import me.filoghost.holographicdisplays.core.api.current.APIHologramManager;
import me.filoghost.holographicdisplays.core.base.BaseHologram;
import me.filoghost.holographicdisplays.core.base.ImmutablePosition;
import me.filoghost.holographicdisplays.core.tracking.LineTrackerManager;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Preconditions;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

class APIHologram
extends BaseHologram
implements Hologram {
    private final APIHologramLines lines;
    private final Plugin plugin;
    private final APIHologramManager hologramManager;
    @NotNull
    private PlaceholderSetting placeholderSetting;

    APIHologram(ImmutablePosition position, Plugin plugin, APIHologramManager hologramManager, LineTrackerManager lineTrackerManager) {
        super(position, lineTrackerManager);
        Preconditions.notNull(plugin, "plugin");
        this.lines = new APIHologramLines(this, lineTrackerManager);
        this.plugin = plugin;
        this.hologramManager = hologramManager;
        this.placeholderSetting = PlaceholderSetting.DEFAULT;
    }

    @Override
    @NotNull
    public APIHologramLines getLines() {
        return this.lines;
    }

    @Override
    public void setPosition(@NotNull Position position) {
        super.setPosition(ImmutablePosition.of(position));
    }

    @Override
    @NotNull
    public PlaceholderSetting getPlaceholderSetting() {
        return this.placeholderSetting;
    }

    @Override
    public void setPlaceholderSetting(@NotNull PlaceholderSetting placeholderSetting) {
        CorePreconditions.checkMainThread();
        Preconditions.notNull((Object)placeholderSetting, "placeholderSetting");
        this.checkNotDeleted();
        if (this.placeholderSetting == placeholderSetting) {
            return;
        }
        this.placeholderSetting = placeholderSetting;
        for (APIHologramLine line : this.lines) {
            line.setChanged();
        }
    }

    @Override
    public Plugin getCreatorPlugin() {
        return this.plugin;
    }

    @Override
    public void delete() {
        this.hologramManager.deleteHologram(this);
    }
}

