/*
 * Decompiled with CFR 0.152.
 */
package net.ess3.provider.providers;

import java.util.Collection;
import net.ess3.provider.PotionMetaProvider;
import net.essentialsx.providers.ProviderData;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;

@ProviderData(description="Legacy 1.8 Potion Meta Provider")
public class PrehistoricPotionMetaProvider
implements PotionMetaProvider {
    @Override
    public ItemStack createPotionItem(Material initial, int effectId) {
        ItemStack potion = new ItemStack(initial, 1);
        potion.setDurability((short)effectId);
        return potion;
    }

    @Override
    public void setSplashPotion(ItemStack stack, boolean isSplash) {
        if (stack == null) {
            throw new IllegalArgumentException("ItemStack cannot be null");
        }
        Potion potion = Potion.fromItemStack((ItemStack)stack);
        potion.setSplash(isSplash);
        potion.apply(stack);
    }

    @Override
    public boolean isSplashPotion(ItemStack stack) {
        return Potion.fromItemStack((ItemStack)stack).isSplash();
    }

    @Override
    public Collection<PotionEffect> getCustomEffects(ItemStack stack) {
        return Potion.fromItemStack((ItemStack)stack).getEffects();
    }

    @Override
    public boolean isExtended(ItemStack stack) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isUpgraded(ItemStack stack) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PotionType getBasePotionType(ItemStack stack) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBasePotionType(ItemStack stack, PotionType type, boolean extended, boolean upgraded) {
        if (stack == null) {
            throw new IllegalArgumentException("ItemStack cannot be null");
        }
        if (extended && upgraded) {
            throw new IllegalArgumentException("Potion cannot be both extended and upgraded");
        }
        Potion potion = Potion.fromItemStack((ItemStack)stack);
        if (extended && !potion.getType().isInstant()) {
            potion.setHasExtendedDuration(true);
            potion.setLevel(Math.min(potion.getLevel(), 1));
        }
        if (upgraded && type.getMaxLevel() == 2) {
            potion.setLevel(2);
            potion.setHasExtendedDuration(false);
        }
        potion.apply(stack);
    }
}

