/*
 * Decompiled with CFR 0.152.
 */
package net.ess3.provider.providers;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import net.ess3.provider.BannerDataProvider;
import net.essentialsx.providers.ProviderData;
import net.essentialsx.providers.ProviderTest;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

@ProviderData(description="1.20.5+ Banner Data Provider", weight=1)
public class BaseBannerDataProvider
implements BannerDataProvider {
    private final BiMap<Material, DyeColor> materialToDyeMap = HashBiMap.create();

    public BaseBannerDataProvider() {
        this.materialToDyeMap.put((Object)Material.WHITE_BANNER, (Object)DyeColor.WHITE);
        this.materialToDyeMap.put((Object)Material.LIGHT_GRAY_BANNER, (Object)DyeColor.LIGHT_GRAY);
        this.materialToDyeMap.put((Object)Material.GRAY_BANNER, (Object)DyeColor.GRAY);
        this.materialToDyeMap.put((Object)Material.BLACK_BANNER, (Object)DyeColor.BLACK);
        this.materialToDyeMap.put((Object)Material.RED_BANNER, (Object)DyeColor.RED);
        this.materialToDyeMap.put((Object)Material.ORANGE_BANNER, (Object)DyeColor.ORANGE);
        this.materialToDyeMap.put((Object)Material.YELLOW_BANNER, (Object)DyeColor.YELLOW);
        this.materialToDyeMap.put((Object)Material.LIME_BANNER, (Object)DyeColor.LIME);
        this.materialToDyeMap.put((Object)Material.GREEN_BANNER, (Object)DyeColor.GREEN);
        this.materialToDyeMap.put((Object)Material.CYAN_BANNER, (Object)DyeColor.CYAN);
        this.materialToDyeMap.put((Object)Material.LIGHT_BLUE_BANNER, (Object)DyeColor.LIGHT_BLUE);
        this.materialToDyeMap.put((Object)Material.BLUE_BANNER, (Object)DyeColor.BLUE);
        this.materialToDyeMap.put((Object)Material.PURPLE_BANNER, (Object)DyeColor.PURPLE);
        this.materialToDyeMap.put((Object)Material.MAGENTA_BANNER, (Object)DyeColor.MAGENTA);
        this.materialToDyeMap.put((Object)Material.PINK_BANNER, (Object)DyeColor.PINK);
        this.materialToDyeMap.put((Object)Material.BROWN_BANNER, (Object)DyeColor.BROWN);
    }

    @Override
    public DyeColor getBaseColor(ItemStack stack) {
        return (DyeColor)this.materialToDyeMap.get((Object)stack.getType());
    }

    @Override
    public void setBaseColor(ItemStack stack, DyeColor color) {
        Material material = (Material)this.materialToDyeMap.inverse().get((Object)color);
        if (material != null) {
            stack.setType(material);
        }
    }

    @ProviderTest
    public static boolean test() {
        try {
            Material needAVariable = Material.LIGHT_BLUE_BANNER;
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }
}

