/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.textreader;

import com.earth2me.essentials.User;
import com.earth2me.essentials.textreader.IText;
import com.earth2me.essentials.utils.AdventureUtil;
import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import net.ess3.api.IEssentials;
import net.ess3.provider.KnownCommandsProvider;
import org.bukkit.command.Command;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;

public class HelpInput
implements IText {
    private final transient List<String> lines = new ArrayList<String>();
    private final transient List<String> chapters = new ArrayList<String>();
    private final transient Map<String, Integer> bookmarks = new HashMap<String, Integer>();

    public HelpInput(User user, String match, IEssentials ess) {
        boolean reported = false;
        ArrayList newLines = new ArrayList();
        String pluginName = "";
        String pluginNameLow = "";
        if (!match.equalsIgnoreCase("")) {
            this.lines.add(AdventureUtil.miniToLegacy(user.playerTl("helpMatching", match)));
        }
        HashMultimap pluginCommands = HashMultimap.create();
        for (Command command : ess.provider(KnownCommandsProvider.class).getKnownCommands().values()) {
            if (!(command instanceof PluginIdentifiableCommand)) continue;
            PluginIdentifiableCommand pluginIdentifiableCommand = (PluginIdentifiableCommand)command;
            pluginCommands.put((Object)pluginIdentifiableCommand.getPlugin(), (Object)command);
        }
        for (Plugin p : ess.getServer().getPluginManager().getPlugins()) {
            try {
                ArrayList<String> pluginLines = new ArrayList<String>();
                PluginDescriptionFile desc = p.getDescription();
                Map cmds = desc.getCommands();
                pluginName = p.getDescription().getName();
                pluginNameLow = pluginName.toLowerCase(Locale.ENGLISH);
                if (pluginNameLow.equals(match)) {
                    this.lines.clear();
                    newLines.clear();
                    this.lines.add(AdventureUtil.miniToLegacy(user.playerTl("helpFrom", p.getDescription().getName())));
                }
                boolean isOnWhitelist = user.isAuthorized("essentials.help." + pluginNameLow);
                for (Command command : pluginCommands.get((Object)p)) {
                    try {
                        String commandName = command.getName();
                        String commandDescription = command.getDescription();
                        if (!match.equalsIgnoreCase("") && !pluginNameLow.contains(match) && !commandName.toLowerCase(Locale.ENGLISH).contains(match) && !commandDescription.toLowerCase(Locale.ENGLISH).contains(match)) continue;
                        if (pluginNameLow.contains("essentials")) {
                            String node = "essentials." + commandName;
                            if (ess.getSettings().isCommandDisabled(commandName) || !user.isAuthorized(node)) continue;
                            pluginLines.add(AdventureUtil.miniToLegacy(user.playerTl("helpLine", commandName, commandDescription)));
                            continue;
                        }
                        if (!ess.getSettings().showNonEssCommandsInHelp()) continue;
                        String permissionRaw = command.getPermission();
                        String[] permissions = permissionRaw == null ? new String[]{} : permissionRaw.split(";");
                        if (isOnWhitelist || user.isAuthorized("essentials.help." + pluginNameLow + "." + commandName)) {
                            pluginLines.add(AdventureUtil.miniToLegacy(user.playerTl("helpLine", commandName, commandDescription)));
                            continue;
                        }
                        if (permissions.length != 0) {
                            boolean enabled = false;
                            for (String permission : permissions) {
                                if (!user.isAuthorized(permission)) continue;
                                enabled = true;
                                break;
                            }
                            if (!enabled) continue;
                            pluginLines.add(AdventureUtil.miniToLegacy(user.playerTl("helpLine", commandName, commandDescription)));
                            continue;
                        }
                        if (ess.getSettings().hidePermissionlessHelp()) continue;
                        pluginLines.add(AdventureUtil.miniToLegacy(user.playerTl("helpLine", commandName, commandDescription)));
                    }
                    catch (NullPointerException nullPointerException) {}
                }
                if (pluginLines.isEmpty()) continue;
                newLines.addAll(pluginLines);
                if (pluginNameLow.equals(match)) break;
                if (!match.equalsIgnoreCase("")) continue;
                this.lines.add(AdventureUtil.miniToLegacy(user.playerTl("helpPlugin", pluginName, pluginNameLow)));
            }
            catch (NullPointerException pluginLines) {
            }
            catch (Exception ex) {
                if (!reported) {
                    ess.getLogger().log(Level.WARNING, AdventureUtil.miniToLegacy(user.playerTl("commandHelpFailedForPlugin", pluginNameLow)), ex);
                }
                reported = true;
            }
        }
        this.lines.addAll(newLines);
    }

    @Override
    public List<String> getLines() {
        return this.lines;
    }

    @Override
    public List<String> getChapters() {
        return this.chapters;
    }

    @Override
    public Map<String, Integer> getBookmarks() {
        return this.bookmarks;
    }
}

