/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.config.serializers;

import com.earth2me.essentials.config.entities.LazyLocation;
import com.earth2me.essentials.libs.checkerframework.checker.nullness.qual.Nullable;
import com.earth2me.essentials.libs.configurate.ConfigurationNode;
import com.earth2me.essentials.libs.configurate.serialize.SerializationException;
import com.earth2me.essentials.libs.configurate.serialize.TypeSerializer;
import java.lang.reflect.Type;

public class LocationTypeSerializer
implements TypeSerializer<LazyLocation> {
    @Override
    public LazyLocation deserialize(Type type, ConfigurationNode node) throws SerializationException {
        String worldValue = node.node("world").getString();
        if (worldValue == null || worldValue.isEmpty()) {
            throw new SerializationException("No world value present!");
        }
        return new LazyLocation(worldValue, node.node("world-name").getString(""), node.node("x").getDouble(), node.node("y").getDouble(), node.node("z").getDouble(), node.node("yaw").getFloat(), node.node("pitch").getFloat());
    }

    @Override
    public void serialize(Type type, @Nullable LazyLocation value, ConfigurationNode node) throws SerializationException {
        if (value == null || value.world() == null) {
            node.raw(null);
            return;
        }
        node.node("world").set(String.class, value.world());
        node.node("world-name").set(String.class, value.worldName());
        node.node("x").set(Double.class, Double.valueOf(value.x()));
        node.node("y").set(Double.class, Double.valueOf(value.y()));
        node.node("z").set(Double.class, Double.valueOf(value.z()));
        node.node("yaw").set(Float.class, Float.valueOf(value.yaw()));
        node.node("pitch").set(Float.class, Float.valueOf(value.pitch()));
    }
}

