/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.utils.AdventureUtil;
import com.earth2me.essentials.utils.MaterialUtil;
import com.earth2me.essentials.utils.NumberUtil;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.ess3.api.TranslatableException;
import org.bukkit.Server;
import org.bukkit.inventory.ItemStack;

public class Commandworth
extends EssentialsCommand {
    public Commandworth() {
        super("worth");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        List<ItemStack> is = this.ess.getItemDb().getMatching(user, args);
        int count = 0;
        boolean isBulk = is.size() > 1;
        BigDecimal totalWorth = BigDecimal.ZERO;
        for (ItemStack stack : is) {
            try {
                if (stack.getAmount() <= 0) continue;
                totalWorth = totalWorth.add(this.itemWorth(user.getSource(), user, stack, args));
                stack = stack.clone();
                ++count;
                for (ItemStack zeroStack : is) {
                    if (!zeroStack.isSimilar(stack)) continue;
                    zeroStack.setAmount(0);
                }
            }
            catch (Exception e) {
                if (isBulk) continue;
                throw e;
            }
        }
        if (count > 1) {
            AdventureUtil.ParsedPlaceholder totalWorthStr = AdventureUtil.parsed(NumberUtil.displayCurrency(totalWorth, this.ess));
            if (args.length > 0 && args[0].equalsIgnoreCase("blocks")) {
                user.sendTl("totalSellableBlocks", totalWorthStr, totalWorthStr);
                return;
            }
            user.sendTl("totalSellableAll", totalWorthStr, totalWorthStr);
        }
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length == 0) {
            throw new NotEnoughArgumentsException();
        }
        this.itemWorth(sender, null, this.ess.getItemDb().get(args[0]), args);
    }

    private BigDecimal itemWorth(CommandSource sender, User user, ItemStack is, String[] args) throws Exception {
        BigDecimal worth;
        int amount = 1;
        if (user == null) {
            if (args.length > 1) {
                try {
                    amount = Integer.parseInt(args[1].replaceAll("[^0-9]", ""));
                }
                catch (NumberFormatException ex) {
                    throw new NotEnoughArgumentsException(ex);
                }
            }
        } else {
            amount = this.ess.getWorth().getAmount(this.ess, user, is, args, true);
        }
        if ((worth = this.ess.getWorth().getPrice(this.ess, is)) == null) {
            throw new TranslatableException("itemCannotBeSold", new Object[0]);
        }
        if (amount < 0) {
            amount = 0;
        }
        BigDecimal result = worth.multiply(BigDecimal.valueOf(amount));
        String typeName = is.getType().toString().toLowerCase(Locale.ENGLISH).replace("_", "");
        AdventureUtil.ParsedPlaceholder resultDisplay = AdventureUtil.parsed(NumberUtil.displayCurrency(result, this.ess));
        AdventureUtil.ParsedPlaceholder worthDisplay = AdventureUtil.parsed(NumberUtil.displayCurrency(worth, this.ess));
        if (MaterialUtil.getDamage(is) != 0) {
            sender.sendTl("worthMeta", typeName, MaterialUtil.getDamage(is), resultDisplay, amount, worthDisplay);
        } else {
            sender.sendTl("worth", typeName, resultDisplay, amount, worthDisplay);
        }
        return result;
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        if (args.length == 1) {
            return this.getMatchingItems(args[0]);
        }
        if (args.length == 2) {
            return Lists.newArrayList((Object[])new String[]{"1", "64"});
        }
        return Collections.emptyList();
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            return this.getItems();
        }
        if (args.length == 2) {
            return Lists.newArrayList((Object[])new String[]{"1", "64"});
        }
        return Collections.emptyList();
    }
}

