/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.Console;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.IUser;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.utils.AdventureUtil;
import com.earth2me.essentials.utils.DateUtil;
import com.earth2me.essentials.utils.FormatUtil;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.BanList;
import org.bukkit.Server;

public class Commandtempban
extends EssentialsCommand {
    public Commandtempban() {
        super("tempban");
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length < 2) {
            throw new NotEnoughArgumentsException();
        }
        User user = this.getPlayer(server, args, 0, true, true);
        if (!user.getBase().isOnline() && sender.isPlayer() && !this.ess.getUser(sender.getPlayer()).isAuthorized("essentials.tempban.offline")) {
            sender.sendTl("tempbanExemptOffline", new Object[0]);
            return;
        }
        if (user.isAuthorized("essentials.tempban.exempt") && sender.isPlayer()) {
            sender.sendTl("tempbanExempt", new Object[0]);
            return;
        }
        String time = Commandtempban.getFinalArg(args, 1);
        long banTimestamp = DateUtil.parseDateDiff(time, true);
        String banReason = FormatUtil.replaceFormat(DateUtil.removeTimePattern(time));
        long maxBanLength = this.ess.getSettings().getMaxTempban() * 1000L;
        if (maxBanLength > 0L && banTimestamp - GregorianCalendar.getInstance().getTimeInMillis() > maxBanLength && sender.isPlayer() && !this.ess.getUser(sender.getPlayer()).isAuthorized("essentials.tempban.unlimited")) {
            sender.sendTl("oversizedTempban", new Object[0]);
            return;
        }
        if (banReason.length() < 2) {
            banReason = I18n.tlLiteral("defaultBanReason", new Object[0]);
        }
        String senderName = sender.isPlayer() ? sender.getPlayer().getDisplayName() : "Console";
        String senderDisplayName = sender.isPlayer() ? sender.getPlayer().getDisplayName() : Console.DISPLAY_NAME;
        this.ess.getServer().getBanList(BanList.Type.NAME).addBan(user.getName(), banReason, new Date(banTimestamp), senderName);
        String expiry = DateUtil.formatDateDiff(banTimestamp);
        String banDisplay = user.playerTl("tempBanned", expiry, senderDisplayName, banReason);
        user.getBase().kickPlayer(AdventureUtil.miniToLegacy(banDisplay));
        this.ess.getLogger().log(Level.INFO, AdventureUtil.miniToLegacy(I18n.tlLiteral("playerTempBanned", senderDisplayName, user.getName(), expiry, banReason)));
        this.ess.broadcastTl((IUser)null, "essentials.ban.notify", "playerTempBanned", senderDisplayName, user.getName(), expiry, banReason);
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            return this.getPlayers(server, sender);
        }
        return COMMON_DATE_DIFFS;
    }
}

