/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.commands.PlayerNotFoundException;
import com.earth2me.essentials.craftbukkit.BanLookup;
import com.earth2me.essentials.utils.AdventureUtil;
import com.earth2me.essentials.utils.CommonPlaceholders;
import com.earth2me.essentials.utils.DateUtil;
import com.earth2me.essentials.utils.FormatUtil;
import com.earth2me.essentials.utils.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import net.ess3.api.TranslatableException;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;

public class Commandseen
extends EssentialsCommand {
    public Commandseen() {
        super("seen");
    }

    @Override
    protected void run(final Server server, final CommandSource sender, final String commandLabel, final String[] args) throws Exception {
        User player;
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        final boolean showBan = sender.isAuthorized("essentials.seen.banreason");
        final boolean showIp = sender.isAuthorized("essentials.seen.ip");
        final boolean showLocation = sender.isAuthorized("essentials.seen.location");
        final boolean showWhitelist = sender.isAuthorized("essentials.seen.whitelist");
        final boolean searchAccounts = commandLabel.contains("alts") && sender.isAuthorized("essentials.seen.alts");
        try {
            UUID uuid = UUID.fromString(args[0]);
            player = this.ess.getUser(uuid);
        }
        catch (IllegalArgumentException ignored) {
            player = this.ess.getOfflineUser(args[0]);
        }
        if (player == null) {
            if (!searchAccounts) {
                if (sender.isAuthorized("essentials.seen.ipsearch") && FormatUtil.validIP(args[0])) {
                    if (this.ess.getServer().getBanList(BanList.Type.IP).isBanned(args[0])) {
                        sender.sendTl("isIpBanned", args[0]);
                    }
                    this.seenIP(sender, args[0], args[0]);
                    return;
                }
                if (this.ess.getServer().getBanList(BanList.Type.IP).isBanned(args[0])) {
                    sender.sendTl("isIpBanned", args[0]);
                    return;
                }
                if (BanLookup.isBanned(this.ess, args[0]).booleanValue()) {
                    sender.sendTl("whoisBanned", showBan ? BanLookup.getBanEntry(this.ess, args[0]).getReason() : sender.tl("true", new Object[0]));
                    return;
                }
            }
            this.ess.getScheduler().runTaskAsynchronously((Plugin)this.ess, new Runnable(){

                @Override
                public void run() {
                    block5: {
                        User userFromBukkit = Commandseen.this.ess.getUsers().getUser(args[0]);
                        try {
                            if (userFromBukkit != null) {
                                this.showUserSeen(userFromBukkit);
                                break block5;
                            }
                            try {
                                this.showUserSeen(Commandseen.this.getPlayer(server, sender, args, 0));
                            }
                            catch (PlayerNotFoundException e) {
                                throw new TranslatableException("playerNeverOnServer", args[0]);
                            }
                        }
                        catch (Exception e) {
                            Commandseen.this.ess.showError(sender, e, commandLabel);
                        }
                    }
                }

                private void showUserSeen(User user) {
                    Commandseen.this.showSeenMessage(sender, user, searchAccounts, showBan, showIp, showLocation, showWhitelist);
                }
            });
        } else {
            this.showSeenMessage(sender, player, searchAccounts, showBan, showIp, showLocation, showWhitelist);
        }
    }

    private void showSeenMessage(CommandSource sender, User player, boolean searchAccounts, boolean showBan, boolean showIp, boolean showLocation, boolean showWhitelist) {
        if (searchAccounts) {
            this.seenIP(sender, player.getLastLoginAddress(), player.getDisplayName());
        } else if (player.getBase().isOnline() && this.canInteractWith(sender, player)) {
            this.seenOnline(sender, player, showIp);
        } else {
            this.seenOffline(sender, player, showBan, showIp, showLocation, showWhitelist);
        }
    }

    private void seenOnline(CommandSource sender, User user, boolean showIp) {
        String location;
        user.setDisplayNick();
        sender.sendTl("seenOnline", user.getDisplayName(), DateUtil.formatDateDiff(user.getLastLogin()));
        List<String> history = user.getPastUsernames();
        if (history != null && !history.isEmpty()) {
            sender.sendTl("seenAccounts", StringUtil.joinListSkip(", ", user.getName(), history));
        }
        if (sender.isAuthorized("essentials.seen.uuid")) {
            sender.sendTl("whoisUuid", user.getBase().getUniqueId().toString());
        }
        if (user.isAfk()) {
            sender.sendTl("whoisAFK", CommonPlaceholders.trueFalse(sender, true));
        }
        if (user.isJailed()) {
            sender.sendTl("whoisJail", user.getJailTimeout() > 0L ? user.getFormattedJailTime() : CommonPlaceholders.trueFalse(sender, true));
        }
        if (user.isMuted()) {
            long muteTimeout = user.getMuteTimeout();
            if (!user.hasMuteReason()) {
                sender.sendTl("whoisMuted", muteTimeout > 0L ? DateUtil.formatDateDiff(muteTimeout) : CommonPlaceholders.trueFalse(sender, true));
            } else {
                sender.sendTl("whoisMutedReason", muteTimeout > 0L ? DateUtil.formatDateDiff(muteTimeout) : CommonPlaceholders.trueFalse(sender, true), user.getMuteReason());
            }
        }
        if ((location = user.getGeoLocation()) != null && (!sender.isPlayer() || this.ess.getUser(sender.getPlayer()).isAuthorized("essentials.geoip.show"))) {
            sender.sendTl("whoisGeoLocation", location);
        }
        if (showIp) {
            sender.sendTl("whoisIPAddress", user.getBase().getAddress().getAddress().toString());
        }
    }

    private void seenOffline(CommandSource sender, User user, boolean showBan, boolean showIp, boolean showLocation, boolean showWhitelist) {
        Location loc;
        String location;
        user.setDisplayNick();
        if (user.getLastLogout() > 0L) {
            sender.sendTl("seenOffline", user.getName(), DateUtil.formatDateDiff(user.getLastLogout()));
            List<String> history = user.getPastUsernames();
            if (history != null && history.size() > 1) {
                sender.sendTl("seenAccounts", StringUtil.joinListSkip(", ", user.getName(), history));
            }
            if (sender.isAuthorized("essentials.seen.uuid")) {
                sender.sendTl("whoisUuid", user.getBase().getUniqueId());
            }
        } else {
            sender.sendTl("userUnknown", user.getName());
        }
        if (showWhitelist) {
            sender.sendTl("whoisWhitelist", CommonPlaceholders.trueFalse(sender, user.getBase().isWhitelisted()));
        }
        if (BanLookup.isBanned(this.ess, user).booleanValue()) {
            BanEntry banEntry = BanLookup.getBanEntry(this.ess, user.getName());
            Object reason = showBan ? banEntry.getReason() : CommonPlaceholders.trueFalse(sender, true);
            sender.sendTl("whoisBanned", reason);
            if (banEntry.getExpiration() != null) {
                Date expiry = banEntry.getExpiration();
                Object expireString = AdventureUtil.parsed(sender.tl("now", new Object[0]));
                if (expiry.after(new Date())) {
                    expireString = DateUtil.formatDateDiff(expiry.getTime());
                }
                sender.sendTl("whoisTempBanned", expireString);
            }
        }
        if (user.isMuted()) {
            long muteTimeout = user.getMuteTimeout();
            if (!user.hasMuteReason()) {
                sender.sendTl("whoisMuted", muteTimeout > 0L ? DateUtil.formatDateDiff(muteTimeout) : CommonPlaceholders.trueFalse(sender, true));
            } else {
                sender.sendTl("whoisMutedReason", muteTimeout > 0L ? DateUtil.formatDateDiff(muteTimeout) : CommonPlaceholders.trueFalse(sender, true), user.getMuteReason());
            }
        }
        if ((location = user.getGeoLocation()) != null && (!sender.isPlayer() || this.ess.getUser(sender.getPlayer()).isAuthorized("essentials.geoip.show"))) {
            sender.sendTl("whoisGeoLocation", location);
        }
        if (showIp && !user.getLastLoginAddress().isEmpty()) {
            sender.sendTl("whoisIPAddress", user.getLastLoginAddress());
        }
        if (showLocation && (loc = user.getLogoutLocation()) != null) {
            sender.sendTl("whoisLocation", loc.getWorld().getName(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
        }
    }

    private void seenIP(CommandSource sender, String ipAddress, String display) {
        sender.sendTl("runningPlayerMatch", AdventureUtil.parsed(AdventureUtil.legacyToMini(display)));
        this.ess.runTaskAsynchronously(() -> {
            ArrayList<String> matches = new ArrayList<String>();
            for (UUID u : this.ess.getUsers().getAllUserUUIDs()) {
                String uIPAddress;
                User user = this.ess.getUsers().loadUncachedUser(u);
                if (user == null || (uIPAddress = user.getLastLoginAddress()).isEmpty() || !uIPAddress.equalsIgnoreCase(ipAddress)) continue;
                matches.add(user.getName());
            }
            if (matches.size() > 0) {
                sender.sendTl("matchingIPAddress", new Object[0]);
                sender.sendTl("matchingAccounts", StringUtil.joinList(matches));
            } else {
                sender.sendTl("noMatchingPlayers", new Object[0]);
            }
        });
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            return this.getPlayers(server, sender);
        }
        return Collections.emptyList();
    }
}

